/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.parser;

import java.util.Vector;
import org.javarosa.xpath.expr.XPathQName;
import org.javarosa.xpath.parser.Token;
import org.javarosa.xpath.parser.XPathSyntaxException;

public class Lexer {
    private static final int CONTEXT_LENGTH = 15;
    public static final int LEX_CONTEXT_VAL = 1;
    public static final int LEX_CONTEXT_OP = 2;

    public static Vector<Token> lex(String expr) throws XPathSyntaxException {
        int skip;
        Vector<Token> tokens = new Vector<Token>();
        int context = 1;
        for (int i = 0; i < expr.length(); i += skip) {
            char c = expr.charAt(i);
            int d = Lexer.getChar(expr, i + 1);
            Token token = null;
            skip = 1;
            if (" \n\t\f\r".indexOf(c) < 0) {
                int len;
                if (c == '=') {
                    token = new Token(9);
                } else if (c == '!' && d == 61) {
                    token = new Token(19);
                    skip = 2;
                } else if (c == '<') {
                    if (d == 61) {
                        token = new Token(15);
                        skip = 2;
                    } else {
                        token = new Token(14);
                    }
                } else if (c == '>') {
                    if (d == 61) {
                        token = new Token(11);
                        skip = 2;
                    } else {
                        token = new Token(10);
                    }
                } else if (c == '+') {
                    token = new Token(23);
                } else if (c == '-') {
                    token = new Token(context == 1 ? 29 : 16);
                } else if (c == '*') {
                    token = new Token(context == 1 ? 32 : 18);
                } else if (c == '|') {
                    token = new Token(30);
                } else if (c == '/') {
                    if (d == 47) {
                        token = new Token(6);
                        skip = 2;
                    } else {
                        token = new Token(27);
                    }
                } else if (c == '[') {
                    token = new Token(12);
                } else if (c == ']') {
                    token = new Token(25);
                } else if (c == '(') {
                    token = new Token(13);
                } else if (c == ')') {
                    token = new Token(26);
                } else if (c == '.') {
                    if (d == 46) {
                        token = new Token(5);
                        skip = 2;
                    } else if (Lexer.isDigit(d)) {
                        skip = Lexer.matchNumeric(expr, i);
                        token = new Token(21, Double.valueOf(expr.substring(i, i + skip)));
                    } else {
                        token = new Token(8);
                    }
                } else if (c == '@') {
                    token = new Token(2);
                } else if (c == ',') {
                    token = new Token(3);
                } else if (c == ':' && d == 58) {
                    token = new Token(4);
                    skip = 2;
                } else if (context == 2 && i + 3 <= expr.length() && "and".equals(expr.substring(i, i + 3))) {
                    token = new Token(1);
                    skip = 3;
                } else if (context == 2 && i + 2 <= expr.length() && "or".equals(expr.substring(i, i + 2))) {
                    token = new Token(22);
                    skip = 2;
                } else if (context == 2 && i + 3 <= expr.length() && "div".equals(expr.substring(i, i + 3))) {
                    token = new Token(7);
                    skip = 3;
                } else if (context == 2 && i + 3 <= expr.length() && "mod".equals(expr.substring(i, i + 3))) {
                    token = new Token(17);
                    skip = 3;
                } else if (c == '$') {
                    len = Lexer.matchQName(expr, i + 1);
                    if (len == 0) {
                        Lexer.badParse(expr, i, c);
                    } else {
                        token = new Token(31, new XPathQName(expr.substring(i + 1, i + len + 1)));
                        skip = len + 1;
                    }
                } else if (c == '\'' || c == '\"') {
                    int end = expr.indexOf(c, i + 1);
                    if (end == -1) {
                        Lexer.badParse(expr, i, c);
                    } else {
                        token = new Token(28, expr.substring(i + 1, end));
                        skip = end - i + 1;
                    }
                } else if (Lexer.isDigit(c)) {
                    skip = Lexer.matchNumeric(expr, i);
                    token = new Token(21, Double.valueOf(expr.substring(i, i + skip)));
                } else if (context == 1 && (Lexer.isAlpha(c) || c == '_')) {
                    len = Lexer.matchQName(expr, i);
                    String name = expr.substring(i, i + len);
                    if (name.indexOf(58) == -1 && Lexer.getChar(expr, i + len) == 58 && Lexer.getChar(expr, i + len + 1) == 42) {
                        token = new Token(20, name);
                        skip = len + 2;
                    } else {
                        token = new Token(24, new XPathQName(name));
                        skip = len;
                    }
                } else {
                    Lexer.badParse(expr, i, c);
                }
            }
            if (token == null) continue;
            context = token.type == 32 || token.type == 20 || token.type == 24 || token.type == 31 || token.type == 21 || token.type == 28 || token.type == 25 || token.type == 26 || token.type == 8 || token.type == 5 ? 2 : 1;
            tokens.addElement(token);
        }
        return tokens;
    }

    private static void badParse(String expr, int i, char c) throws XPathSyntaxException {
        String start = "\u034e" + c;
        String preContext = (Math.max(0, i - 15) != 0 ? "..." : "") + expr.substring(Math.max(0, i - 15), Math.max(0, i)).trim();
        String postcontext = i == expr.length() - 1 ? "" : expr.substring(Math.min(i + 1, expr.length() - 1), Math.min(i + 15, expr.length())).trim() + (Math.min(i + 15, expr.length()) != expr.length() ? "..." : "");
        throw new XPathSyntaxException("Couldn't understand the expression starting at this point: " + preContext + start + postcontext);
    }

    private static int matchNumeric(String expr, int i) {
        char c;
        boolean seenDecimalPoint = false;
        int start = i;
        while (i < expr.length() && (Lexer.isDigit(c = expr.charAt(i)) || !seenDecimalPoint && c == '.')) {
            if (c == '.') {
                seenDecimalPoint = true;
            }
            ++i;
        }
        return i - start;
    }

    private static int matchQName(String expr, int i) {
        int len2;
        int len = Lexer.matchNCName(expr, i);
        if (len > 0 && Lexer.getChar(expr, i + len) == 58 && (len2 = Lexer.matchNCName(expr, i + len + 1)) > 0) {
            len += len2 + 1;
        }
        return len;
    }

    private static int matchNCName(String expr, int i) {
        char c;
        int start = i;
        while (i < expr.length() && (Lexer.isAlpha(c = expr.charAt(i)) || c == '_' || i > start && (Lexer.isDigit(c) || c == '.' || c == '-'))) {
            ++i;
        }
        return i - start;
    }

    private static int getChar(String expr, int i) {
        return i < expr.length() ? (int)expr.charAt(i) : -1;
    }

    private static boolean isDigit(int c) {
        return c < 0 ? false : Character.isDigit((char)c);
    }

    private static boolean isAlpha(int c) {
        return c < 0 ? false : Character.isLowerCase((char)c) || Character.isUpperCase((char)c);
    }
}

