/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.parser.ast;

import java.util.Vector;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathNumericLiteral;
import org.javarosa.xpath.expr.XPathQName;
import org.javarosa.xpath.expr.XPathStringLiteral;
import org.javarosa.xpath.expr.XPathVariableReference;
import org.javarosa.xpath.parser.Parser;
import org.javarosa.xpath.parser.Token;
import org.javarosa.xpath.parser.XPathSyntaxException;
import org.javarosa.xpath.parser.ast.ASTNode;
import org.javarosa.xpath.parser.ast.ASTNodePathStep;
import org.javarosa.xpath.parser.ast.ASTNodePredicate;

public class ASTNodeAbstractExpr
extends ASTNode {
    public static final int CHILD = 1;
    public static final int TOKEN = 2;
    public Vector<Object> content = new Vector();

    @Override
    public Vector<ASTNode> getChildren() {
        Vector<ASTNode> children = new Vector<ASTNode>();
        for (int i = 0; i < this.content.size(); ++i) {
            if (this.getType(i) != 1) continue;
            children.addElement((ASTNode)this.content.elementAt(i));
        }
        return children;
    }

    @Override
    public XPathExpression build() throws XPathSyntaxException {
        if (this.content.size() == 1) {
            if (this.getType(0) == 1) {
                return ((ASTNode)this.content.elementAt(0)).build();
            }
            switch (this.getTokenType(0)) {
                case 21: {
                    return new XPathNumericLiteral((Double)this.getToken((int)0).val);
                }
                case 28: {
                    return new XPathStringLiteral((String)this.getToken((int)0).val);
                }
                case 31: {
                    return new XPathVariableReference((XPathQName)this.getToken((int)0).val);
                }
            }
            throw new XPathSyntaxException();
        }
        throw new XPathSyntaxException();
    }

    public boolean isTerminal() {
        if (this.content.size() == 1) {
            int type = this.getTokenType(0);
            return type == 21 || type == 28 || type == 31;
        }
        return false;
    }

    public boolean isNormalized() {
        if (this.content.size() == 1 && this.getType(0) == 1) {
            ASTNode child = (ASTNode)this.content.elementAt(0);
            if (child instanceof ASTNodePathStep || child instanceof ASTNodePredicate) {
                throw new RuntimeException("shouldn't happen");
            }
            return true;
        }
        return this.isTerminal();
    }

    public int getType(int i) {
        Object o = this.content.elementAt(i);
        if (o instanceof Token) {
            return 2;
        }
        if (o instanceof ASTNode) {
            return 1;
        }
        return -1;
    }

    public Token getToken(int i) {
        return this.getType(i) == 2 ? (Token)this.content.elementAt(i) : null;
    }

    public int getTokenType(int i) {
        Token t = this.getToken(i);
        return t == null ? -1 : t.type;
    }

    public ASTNodeAbstractExpr extract(int start, int end) {
        ASTNodeAbstractExpr node = new ASTNodeAbstractExpr();
        for (int i = start; i < end; ++i) {
            node.content.addElement(this.content.elementAt(i));
        }
        return node;
    }

    public void condense(ASTNode node, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            this.content.removeElementAt(i);
        }
        this.content.insertElementAt(node, start);
    }

    public int indexOfBalanced(int start, int target, int leftPush, int rightPop) {
        int i;
        int depth = 0;
        boolean found = false;
        for (i = start + 1; depth >= 0 && i < this.content.size(); ++i) {
            int type = this.getTokenType(i);
            if (depth == 0 && type == target) {
                found = true;
                break;
            }
            if (type == leftPush) {
                ++depth;
                continue;
            }
            if (type != rightPop) continue;
            --depth;
        }
        return found ? i : -1;
    }

    public Partition partition(int[] separators, int start, int end) {
        int i;
        Partition part = new Partition();
        Vector<Integer> sepIdxs = new Vector<Integer>();
        block0: for (i = start; i < end; ++i) {
            for (int j = 0; j < separators.length; ++j) {
                if (this.getTokenType(i) != separators[j]) continue;
                part.separators.addElement(separators[j]);
                sepIdxs.addElement(i);
                continue block0;
            }
        }
        for (i = 0; i <= sepIdxs.size(); ++i) {
            int pieceStart = i == 0 ? start : Parser.vectInt(sepIdxs, i - 1) + 1;
            int pieceEnd = i == sepIdxs.size() ? end : Parser.vectInt(sepIdxs, i);
            part.pieces.addElement(this.extract(pieceStart, pieceEnd));
        }
        return part;
    }

    public Partition partitionBalanced(int sep, int start, int leftPush, int rightPop) {
        Partition part = new Partition();
        Vector<Integer> sepIdxs = new Vector<Integer>();
        int end = this.indexOfBalanced(start, rightPop, leftPush, rightPop);
        if (end == -1) {
            return null;
        }
        int k = start;
        do {
            if ((k = this.indexOfBalanced(k, sep, leftPush, rightPop)) == -1) continue;
            sepIdxs.addElement(k);
            part.separators.addElement(sep);
        } while (k != -1);
        for (int i = 0; i <= sepIdxs.size(); ++i) {
            int pieceStart = i == 0 ? start + 1 : Parser.vectInt(sepIdxs, i - 1) + 1;
            int pieceEnd = i == sepIdxs.size() ? end : Parser.vectInt(sepIdxs, i);
            part.pieces.addElement(this.extract(pieceStart, pieceEnd));
        }
        return part;
    }

    public class Partition {
        public Vector<ASTNode> pieces = new Vector();
        public Vector<Integer> separators = new Vector();
    }
}

