/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.parser.ast;

import java.util.Vector;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathQName;
import org.javarosa.xpath.expr.XPathStep;
import org.javarosa.xpath.parser.XPathSyntaxException;
import org.javarosa.xpath.parser.ast.ASTNode;
import org.javarosa.xpath.parser.ast.ASTNodeAbstractExpr;
import org.javarosa.xpath.parser.ast.ASTNodeFunctionCall;

public class ASTNodePathStep
extends ASTNode {
    public static final int AXIS_TYPE_ABBR = 1;
    public static final int AXIS_TYPE_EXPLICIT = 2;
    public static final int AXIS_TYPE_NULL = 3;
    public static final int NODE_TEST_TYPE_QNAME = 1;
    public static final int NODE_TEST_TYPE_WILDCARD = 2;
    public static final int NODE_TEST_TYPE_NSWILDCARD = 3;
    public static final int NODE_TEST_TYPE_ABBR_DOT = 4;
    public static final int NODE_TEST_TYPE_ABBR_DBL_DOT = 5;
    public static final int NODE_TEST_TYPE_FUNC = 6;
    public int axisType;
    public int axisVal;
    public int nodeTestType;
    public ASTNodeFunctionCall nodeTestFunc;
    public XPathQName nodeTestQName;
    public String nodeTestNamespace;
    public Vector<ASTNode> predicates = new Vector();

    @Override
    public Vector<ASTNode> getChildren() {
        return this.predicates;
    }

    @Override
    public XPathExpression build() {
        return null;
    }

    public XPathStep getStep() throws XPathSyntaxException {
        XPathStep step;
        if (this.nodeTestType == 4) {
            return XPathStep.ABBR_SELF();
        }
        if (this.nodeTestType == 5) {
            return XPathStep.ABBR_PARENT();
        }
        if (this.axisType == 3) {
            this.axisVal = 0;
        } else if (this.axisType == 1) {
            this.axisVal = 8;
        }
        if (this.nodeTestType == 1) {
            step = new XPathStep(this.axisVal, this.nodeTestQName);
        } else if (this.nodeTestType == 2) {
            step = new XPathStep(this.axisVal, 1);
        } else if (this.nodeTestType == 3) {
            step = new XPathStep(this.axisVal, this.nodeTestNamespace);
        } else {
            int type;
            String funcName = this.nodeTestFunc.name.toString();
            if (funcName.equals("node")) {
                type = 3;
            } else if (funcName.equals("text")) {
                type = 4;
            } else if (funcName.equals("comment")) {
                type = 5;
            } else if (funcName.equals("processing-instruction")) {
                type = 6;
            } else {
                throw new RuntimeException();
            }
            step = new XPathStep(this.axisVal, type);
            if (this.nodeTestFunc.args.size() > 0) {
                step.literal = (String)((ASTNodeAbstractExpr)this.nodeTestFunc.args.elementAt((int)0)).getToken((int)0).val;
            }
        }
        XPathExpression[] preds = new XPathExpression[this.predicates.size()];
        for (int i = 0; i < preds.length; ++i) {
            preds[i] = this.predicates.elementAt(i).build();
        }
        step.predicates = preds;
        return step;
    }

    public static int validateAxisName(String axisName) {
        int axis = -1;
        if (axisName.equals("child")) {
            axis = 0;
        } else if (axisName.equals("descendant")) {
            axis = 1;
        } else if (axisName.equals("parent")) {
            axis = 2;
        } else if (axisName.equals("ancestor")) {
            axis = 3;
        } else if (axisName.equals("following-sibling")) {
            axis = 4;
        } else if (axisName.equals("preceding-sibling")) {
            axis = 5;
        } else if (axisName.equals("following")) {
            axis = 6;
        } else if (axisName.equals("preceding")) {
            axis = 7;
        } else if (axisName.equals("attribute")) {
            axis = 8;
        } else if (axisName.equals("namespace")) {
            axis = 9;
        } else if (axisName.equals("self")) {
            axis = 10;
        } else if (axisName.equals("descendant-or-self")) {
            axis = 11;
        } else if (axisName.equals("ancestor-or-self")) {
            axis = 12;
        }
        return axis;
    }

    public static boolean validateNodeTypeTest(ASTNodeFunctionCall f) {
        String name = f.name.toString();
        if (name.equals("node") || name.equals("text") || name.equals("comment") || name.equals("processing-instruction")) {
            if (f.args.size() == 0) {
                return true;
            }
            if (name.equals("processing-instruction") && f.args.size() == 1) {
                ASTNodeAbstractExpr x = (ASTNodeAbstractExpr)f.args.elementAt(0);
                return x.content.size() == 1 && x.getTokenType(0) == 28;
            }
            return false;
        }
        return false;
    }
}

