package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.cipher.suite.CipherSuites;
import org.opendaylight.yang.svc.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa-cert-mdsal</b>
 * <pre>
 * grouping cipher-suite {
 *   list cipher-suites {
 *     leaf suiteName {
 *       type string;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface CipherSuite
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("cipher-suite");

    @Override
    Class<? extends CipherSuite> implementedInterface();
    
    /**
     * Return cipherSuites, or {@code null} if it is not present.
     *
     * @return {@code List<CipherSuites>} cipherSuites, or {@code null} if it is not present.
     *
     */
    @Nullable List<CipherSuites> getCipherSuites();
    
    /**
     * Return cipherSuites, or an empty list if it is not present.
     *
     * @return {@code List<CipherSuites>} cipherSuites, or an empty list if it is not present.
     *
     */
    default @NonNull List<CipherSuites> nonnullCipherSuites() {
        return CodeHelpers.nonnull(getCipherSuites());
    }

}

