package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslDataKey;
import org.opendaylight.yang.svc.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa-cert-mdsal</b>
 * <pre>
 * container key-stores {
 *   leaf id {
 *     type string;
 *   }
 *   list ssl-data {
 *     key bundle-name;
 *     uses ssl-data;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link KeyStoresBuilder}.
 * @see KeyStoresBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface KeyStores
    extends
    ChildOf<AaaCertMdsalData>,
    Augmentable<KeyStores>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("key-stores");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.KeyStores> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.KeyStores.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.@NonNull KeyStores obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getId());
        result = prime * result + Objects.hashCode(obj.getSslData());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.@NonNull KeyStores thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.KeyStores.class, obj);
        return other != null
            && Objects.equals(thisObj.getId(), other.getId())
            && Objects.equals(thisObj.getSslData(), other.getSslData())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.@NonNull KeyStores obj) {
        final var helper = MoreObjects.toStringHelper("KeyStores");
        CodeHelpers.appendValue(helper, "id", obj.getId());
        CodeHelpers.appendValue(helper, "sslData", obj.getSslData());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return id, or {@code null} if it is not present.
     *
     * @return {@code String} id, or {@code null} if it is not present.
     *
     */
    String getId();
    
    /**
     * Return id, guaranteed to be non-null.
     *
     * @return {@code String} id, guaranteed to be non-null.
     * @throws NoSuchElementException if id is not present
     *
     */
    default @NonNull String requireId() {
        return CodeHelpers.require(getId(), "id");
    }
    
    /**
     * Return sslData, or {@code null} if it is not present.
     *
     * @return {@code Map<SslDataKey, SslData>} sslData, or {@code null} if it is not present.
     *
     */
    @Nullable Map<SslDataKey, SslData> getSslData();
    
    /**
     * Return sslData, or an empty list if it is not present.
     *
     * @return {@code Map<SslDataKey, SslData>} sslData, or an empty list if it is not present.
     *
     */
    default @NonNull Map<SslDataKey, SslData> nonnullSslData() {
        return CodeHelpers.nonnull(getSslData());
    }

}

