package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa-cert-mdsal</b>
 * <pre>
 * grouping keystore {
 *   leaf name {
 *     type string;
 *   }
 *   leaf alias {
 *     type string;
 *   }
 *   leaf store-password {
 *     type string;
 *   }
 *   leaf dname {
 *     type string;
 *   }
 *   leaf validity {
 *     type int32;
 *   }
 *   leaf key-alg {
 *     type string;
 *   }
 *   leaf sign-alg {
 *     type string;
 *   }
 *   leaf keysize {
 *     type int32;
 *   }
 *   leaf keystoreFile {
 *     type binary;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface Keystore
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("keystore");

    @Override
    Class<? extends Keystore> implementedInterface();
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         keystore name
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         keystore name
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return alias, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         key alias
     *     </code>
     * </pre>
     *
     * @return {@code String} alias, or {@code null} if it is not present.
     *
     */
    String getAlias();
    
    /**
     * Return alias, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         key alias
     *     </code>
     * </pre>
     *
     * @return {@code String} alias, guaranteed to be non-null.
     * @throws NoSuchElementException if alias is not present
     *
     */
    default @NonNull String requireAlias() {
        return CodeHelpers.require(getAlias(), "alias");
    }
    
    /**
     * Return storePassword, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         keystore password
     *     </code>
     * </pre>
     *
     * @return {@code String} storePassword, or {@code null} if it is not present.
     *
     */
    String getStorePassword();
    
    /**
     * Return storePassword, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         keystore password
     *     </code>
     * </pre>
     *
     * @return {@code String} storePassword, guaranteed to be non-null.
     * @throws NoSuchElementException if storePassword is not present
     *
     */
    default @NonNull String requireStorePassword() {
        return CodeHelpers.require(getStorePassword(), "storepassword");
    }
    
    /**
     * Return dname, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         X.500 Distinguished Names should be in the following formate CN=commonName
     *         OU=organizationUnit O=organizationName L=localityName S=stateName C=country
     *     </code>
     * </pre>
     *
     * @return {@code String} dname, or {@code null} if it is not present.
     *
     */
    String getDname();
    
    /**
     * Return dname, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         X.500 Distinguished Names should be in the following formate CN=commonName
     *         OU=organizationUnit O=organizationName L=localityName S=stateName C=country
     *     </code>
     * </pre>
     *
     * @return {@code String} dname, guaranteed to be non-null.
     * @throws NoSuchElementException if dname is not present
     *
     */
    default @NonNull String requireDname() {
        return CodeHelpers.require(getDname(), "dname");
    }
    
    /**
     * Return validity, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         validity
     *     </code>
     * </pre>
     *
     * @return {@code Integer} validity, or {@code null} if it is not present.
     *
     */
    Integer getValidity();
    
    /**
     * Return validity, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         validity
     *     </code>
     * </pre>
     *
     * @return {@code Integer} validity, guaranteed to be non-null.
     * @throws NoSuchElementException if validity is not present
     *
     */
    default @NonNull Integer requireValidity() {
        return CodeHelpers.require(getValidity(), "validity");
    }
    
    /**
     * Return keyAlg, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         supported key geneartion algorithmes are DSA and RSA
     *     </code>
     * </pre>
     *
     * @return {@code String} keyAlg, or {@code null} if it is not present.
     *
     */
    String getKeyAlg();
    
    /**
     * Return keyAlg, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         supported key geneartion algorithmes are DSA and RSA
     *     </code>
     * </pre>
     *
     * @return {@code String} keyAlg, guaranteed to be non-null.
     * @throws NoSuchElementException if keyAlg is not present
     *
     */
    default @NonNull String requireKeyAlg() {
        return CodeHelpers.require(getKeyAlg(), "keyalg");
    }
    
    /**
     * Return signAlg, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         supported sign algorithmes for DSA the default sign Alg is SHA1withDSA and for
     *         RSA the default sign Alg is MD5withRSA
     *     </code>
     * </pre>
     *
     * @return {@code String} signAlg, or {@code null} if it is not present.
     *
     */
    String getSignAlg();
    
    /**
     * Return signAlg, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         supported sign algorithmes for DSA the default sign Alg is SHA1withDSA and for
     *         RSA the default sign Alg is MD5withRSA
     *     </code>
     * </pre>
     *
     * @return {@code String} signAlg, guaranteed to be non-null.
     * @throws NoSuchElementException if signAlg is not present
     *
     */
    default @NonNull String requireSignAlg() {
        return CodeHelpers.require(getSignAlg(), "signalg");
    }
    
    /**
     * Return keysize, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         key size is 1024 or 2048
     *     </code>
     * </pre>
     *
     * @return {@code Integer} keysize, or {@code null} if it is not present.
     *
     */
    Integer getKeysize();
    
    /**
     * Return keysize, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         key size is 1024 or 2048
     *     </code>
     * </pre>
     *
     * @return {@code Integer} keysize, guaranteed to be non-null.
     * @throws NoSuchElementException if keysize is not present
     *
     */
    default @NonNull Integer requireKeysize() {
        return CodeHelpers.require(getKeysize(), "keysize");
    }
    
    /**
     * Return keystoreFile, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         keystore file as Binary
     *     </code>
     * </pre>
     *
     * @return {@code byte[]} keystoreFile, or {@code null} if it is not present.
     *
     */
    byte[] getKeystoreFile();
    
    /**
     * Return keystoreFile, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         keystore file as Binary
     *     </code>
     * </pre>
     *
     * @return {@code byte[]} keystoreFile, guaranteed to be non-null.
     * @throws NoSuchElementException if keystoreFile is not present
     *
     */
    default byte @NonNull[] requireKeystoreFile() {
        return CodeHelpers.require(getKeystoreFile(), "keystorefile");
    }

}

