package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa-cert-mdsal</b>
 * <pre>
 * grouping node-certificate {
 *   leaf alias {
 *     type string;
 *   }
 *   leaf x500-certificate {
 *     type string;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface NodeCertificate
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("node-certificate");

    @Override
    Class<? extends NodeCertificate> implementedInterface();
    
    /**
     * Return alias, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         network node certificate alias
     *     </code>
     * </pre>
     *
     * @return {@code String} alias, or {@code null} if it is not present.
     *
     */
    String getAlias();
    
    /**
     * Return alias, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         network node certificate alias
     *     </code>
     * </pre>
     *
     * @return {@code String} alias, guaranteed to be non-null.
     * @throws NoSuchElementException if alias is not present
     *
     */
    default @NonNull String requireAlias() {
        return CodeHelpers.require(getAlias(), "alias");
    }
    
    /**
     * Return x500Certificate, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         network node certificate
     *     </code>
     * </pre>
     *
     * @return {@code String} x500Certificate, or {@code null} if it is not present.
     *
     */
    String getX500Certificate();
    
    /**
     * Return x500Certificate, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         network node certificate
     *     </code>
     * </pre>
     *
     * @return {@code String} x500Certificate, guaranteed to be non-null.
     * @throws NoSuchElementException if x500Certificate is not present
     *
     */
    default @NonNull String requireX500Certificate() {
        return CodeHelpers.require(getX500Certificate(), "x500certificate");
    }

}

