package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.OdlKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.TrustKeystore;
import org.opendaylight.yang.svc.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa-cert-mdsal</b>
 * <pre>
 * grouping ssl-data {
 *   leaf bundle-name {
 *     type string;
 *   }
 *   leaf tls-protocols {
 *     type string;
 *   }
 *   container odl-keystore {
 *     uses keystore;
 *   }
 *   container trust-keystore {
 *     uses keystore;
 *   }
 *   uses cipher-suite;
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SslData
    extends
    DataObject,
    CipherSuite
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("ssl-data");

    @Override
    Class<? extends SslData> implementedInterface();
    
    /**
     * Return bundleName, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         bundle name
     *     </code>
     * </pre>
     *
     * @return {@code String} bundleName, or {@code null} if it is not present.
     *
     */
    String getBundleName();
    
    /**
     * Return bundleName, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         bundle name
     *     </code>
     * </pre>
     *
     * @return {@code String} bundleName, guaranteed to be non-null.
     * @throws NoSuchElementException if bundleName is not present
     *
     */
    default @NonNull String requireBundleName() {
        return CodeHelpers.require(getBundleName(), "bundlename");
    }
    
    /**
     * Return tlsProtocols, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         the TLS supported protocols (SSLv2Hello,TLSv1.1,TLSv1.2) the selected protocol
     *         should be seperated by ',' char
     *     </code>
     * </pre>
     *
     * @return {@code String} tlsProtocols, or {@code null} if it is not present.
     *
     */
    String getTlsProtocols();
    
    /**
     * Return tlsProtocols, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         the TLS supported protocols (SSLv2Hello,TLSv1.1,TLSv1.2) the selected protocol
     *         should be seperated by ',' char
     *     </code>
     * </pre>
     *
     * @return {@code String} tlsProtocols, guaranteed to be non-null.
     * @throws NoSuchElementException if tlsProtocols is not present
     *
     */
    default @NonNull String requireTlsProtocols() {
        return CodeHelpers.require(getTlsProtocols(), "tlsprotocols");
    }
    
    /**
     * Return odlKeystore, or {@code null} if it is not present.
     *
     * @return {@code OdlKeystore} odlKeystore, or {@code null} if it is not present.
     *
     */
    OdlKeystore getOdlKeystore();
    
    /**
     * Return odlKeystore, or an empty instance if it is not present.
     *
     * @return {@code OdlKeystore} odlKeystore, or an empty instance if it is not present.
     *
     */
    @NonNull OdlKeystore nonnullOdlKeystore();
    
    /**
     * Return trustKeystore, or {@code null} if it is not present.
     *
     * @return {@code TrustKeystore} trustKeystore, or {@code null} if it is not present.
     *
     */
    TrustKeystore getTrustKeystore();
    
    /**
     * Return trustKeystore, or an empty instance if it is not present.
     *
     * @return {@code TrustKeystore} trustKeystore, or an empty instance if it is not present.
     *
     */
    @NonNull TrustKeystore nonnullTrustKeystore();

}

