package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.KeyStores;
import org.opendaylight.yang.svc.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa-cert-mdsal</b>
 * <pre>
 * list ssl-data {
 *   key bundle-name;
 *   uses ssl-data;
 * }
 * </pre>
 * <p>To create instances of this class use {@link SslDataBuilder}.
 * @see SslDataBuilder
 * @see SslDataKey
 *
 */
@Generated("mdsal-binding-generator")
public interface SslData
    extends
    ChildOf<KeyStores>,
    Augmentable<SslData>,
    org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.SslData,
    KeyAware<SslDataKey>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("ssl-data");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.@NonNull SslData obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getBundleName());
        result = prime * result + Objects.hashCode(obj.getCipherSuites());
        result = prime * result + Objects.hashCode(obj.getOdlKeystore());
        result = prime * result + Objects.hashCode(obj.getTlsProtocols());
        result = prime * result + Objects.hashCode(obj.getTrustKeystore());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.@NonNull SslData thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData.class, obj);
        return other != null
            && Objects.equals(thisObj.getBundleName(), other.getBundleName())
            && Objects.equals(thisObj.getTlsProtocols(), other.getTlsProtocols())
            && Objects.equals(thisObj.getCipherSuites(), other.getCipherSuites())
            && Objects.equals(thisObj.getOdlKeystore(), other.getOdlKeystore())
            && Objects.equals(thisObj.getTrustKeystore(), other.getTrustKeystore())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.@NonNull SslData obj) {
        final var helper = MoreObjects.toStringHelper("SslData");
        CodeHelpers.appendValue(helper, "bundleName", obj.getBundleName());
        CodeHelpers.appendValue(helper, "cipherSuites", obj.getCipherSuites());
        CodeHelpers.appendValue(helper, "odlKeystore", obj.getOdlKeystore());
        CodeHelpers.appendValue(helper, "tlsProtocols", obj.getTlsProtocols());
        CodeHelpers.appendValue(helper, "trustKeystore", obj.getTrustKeystore());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    SslDataKey key();

}

