package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.CipherSuite;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.cipher.suite.CipherSuites;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.OdlKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.TrustKeystore;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SslData} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SslData createSslData(int fooXyzzy, int barBaz) {
 *         return new SslDataBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SslData, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SslData
 *
 */
@Generated("mdsal-binding-generator")
public class SslDataBuilder {

    private String _bundleName;
    private List<CipherSuites> _cipherSuites;
    private OdlKeystore _odlKeystore;
    private String _tlsProtocols;
    private TrustKeystore _trustKeystore;
    private SslDataKey key;


    Map<Class<? extends Augmentation<SslData>>, Augmentation<SslData>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public SslDataBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.SslData}.
     *
     * @param arg org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.SslData from which the builder should be initialized
     */
    public SslDataBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.SslData arg) {
        this._bundleName = arg.getBundleName();
        this._tlsProtocols = arg.getTlsProtocols();
        this._odlKeystore = arg.getOdlKeystore();
        this._trustKeystore = arg.getTrustKeystore();
        this._cipherSuites = arg.getCipherSuites();
    }
    
    /**
     * Construct a new builder initialized from specified {@link CipherSuite}.
     *
     * @param arg CipherSuite from which the builder should be initialized
     */
    public SslDataBuilder(CipherSuite arg) {
        this._cipherSuites = arg.getCipherSuites();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link SslData}.
     *
     * @param base SslData from which the builder should be initialized
     */
    public SslDataBuilder(SslData base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._bundleName = base.getBundleName();
        this._cipherSuites = base.getCipherSuites();
        this._odlKeystore = base.getOdlKeystore();
        this._tlsProtocols = base.getTlsProtocols();
        this._trustKeystore = base.getTrustKeystore();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link CipherSuite}</li>
     *   <li>{@link org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.SslData}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CipherSuite castArg) {
            this._cipherSuites = castArg.getCipherSuites();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.SslData castArg) {
            this._bundleName = castArg.getBundleName();
            this._tlsProtocols = castArg.getTlsProtocols();
            this._odlKeystore = castArg.getOdlKeystore();
            this._trustKeystore = castArg.getTrustKeystore();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[CipherSuite, org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.SslData]");
    }


    /**
     * Return current value associated with the property corresponding to {@link SslData#key()}.
     *
     * @return current value
     */
    public SslDataKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SslData#getBundleName()}.
     *
     * @return current value
     */
    public String getBundleName() {
        return _bundleName;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SslData#getCipherSuites()}.
     *
     * @return current value
     */
    public List<CipherSuites> getCipherSuites() {
        return _cipherSuites;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SslData#getOdlKeystore()}.
     *
     * @return current value
     */
    public OdlKeystore getOdlKeystore() {
        return _odlKeystore;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SslData#getTlsProtocols()}.
     *
     * @return current value
     */
    public String getTlsProtocols() {
        return _tlsProtocols;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SslData#getTrustKeystore()}.
     *
     * @return current value
     */
    public TrustKeystore getTrustKeystore() {
        return _trustKeystore;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SslData>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link SslData#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public SslDataBuilder withKey(final SslDataKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SslData#getBundleName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SslDataBuilder setBundleName(final String value) {
        this._bundleName = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SslData#getCipherSuites()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public SslDataBuilder setCipherSuites(final List<CipherSuites> values) {
        this._cipherSuites = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link SslData#getOdlKeystore()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SslDataBuilder setOdlKeystore(final OdlKeystore value) {
        this._odlKeystore = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SslData#getTlsProtocols()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SslDataBuilder setTlsProtocols(final String value) {
        this._tlsProtocols = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SslData#getTrustKeystore()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SslDataBuilder setTrustKeystore(final TrustKeystore value) {
        this._trustKeystore = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SslDataBuilder addAugmentation(Augmentation<SslData> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SslDataBuilder removeAugmentation(Class<? extends Augmentation<SslData>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link SslData} instance.
     *
     * @return A new {@link SslData} instance.
     */
    public @NonNull SslData build() {
        return new SslDataImpl(this);
    }

    private static final class SslDataImpl
        extends AbstractAugmentable<SslData>
        implements SslData {
    
        private final String _bundleName;
        private final List<CipherSuites> _cipherSuites;
        private final OdlKeystore _odlKeystore;
        private final String _tlsProtocols;
        private final TrustKeystore _trustKeystore;
        private final SslDataKey key;
    
        SslDataImpl(SslDataBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new SslDataKey(base.getBundleName());
            }
            this._bundleName = key.getBundleName();
            this._cipherSuites = CodeHelpers.emptyToNull(base.getCipherSuites());
            this._odlKeystore = base.getOdlKeystore();
            this._tlsProtocols = base.getTlsProtocols();
            this._trustKeystore = base.getTrustKeystore();
        }
    
        @Override
        public SslDataKey key() {
            return key;
        }
        
        @Override
        public String getBundleName() {
            return _bundleName;
        }
        
        @Override
        public List<CipherSuites> getCipherSuites() {
            return _cipherSuites;
        }
        
        @Override
        public OdlKeystore getOdlKeystore() {
            return _odlKeystore;
        }
        
        @Override
        public String getTlsProtocols() {
            return _tlsProtocols;
        }
        
        @Override
        public TrustKeystore getTrustKeystore() {
            return _trustKeystore;
        }
    
        
        
        @Override
        public OdlKeystore nonnullOdlKeystore() {
            return Objects.requireNonNullElse(getOdlKeystore(), org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.OdlKeystoreBuilder.empty());
        }
        
        
        @Override
        public TrustKeystore nonnullTrustKeystore() {
            return Objects.requireNonNullElse(getTrustKeystore(), org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.TrustKeystoreBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = SslData.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return SslData.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return SslData.bindingToString(this);
        }
    }
}
