package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;

/**
 * This class represents the key of {@link SslData} class.
 *
 * @see SslData
 *
 */
@Generated("mdsal-binding-generator")
public class SslDataKey
 implements Key<SslData> {
    @java.io.Serial
    private static final long serialVersionUID = 1370038356611832986L;
    private final String _bundleName;


    /**
     * Constructs an instance.
     *
     * @param _bundleName the entity bundleName
     * @throws NullPointerException if any of the arguments are null
     */
    public SslDataKey(@NonNull String _bundleName) {
        this._bundleName = CodeHelpers.requireKeyProp(_bundleName, "bundleName");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public SslDataKey(SslDataKey source) {
        this._bundleName = source._bundleName;
    }


    /**
     * Return bundleName, guaranteed to be non-null.
     *
     * @return {@code String} bundleName, guaranteed to be non-null.
     */
    public @NonNull String getBundleName() {
        return _bundleName;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_bundleName);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof SslDataKey other
            && Objects.equals(_bundleName, other._bundleName);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(SslDataKey.class);
        CodeHelpers.appendValue(helper, "bundleName", _bundleName);
        return helper.toString();
    }
}

