package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.Keystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.SslData;
import org.opendaylight.yang.svc.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa-cert-mdsal</b>
 * <pre>
 * container odl-keystore {
 *   uses keystore;
 * }
 * </pre>
 * <p>To create instances of this class use {@link OdlKeystoreBuilder}.
 * @see OdlKeystoreBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface OdlKeystore
    extends
    ChildOf<SslData>,
    Augmentable<OdlKeystore>,
    Keystore
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("odl-keystore");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.OdlKeystore> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.OdlKeystore.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.@NonNull OdlKeystore obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getAlias());
        result = prime * result + Objects.hashCode(obj.getDname());
        result = prime * result + Objects.hashCode(obj.getKeyAlg());
        result = prime * result + Objects.hashCode(obj.getKeysize());
        result = prime * result + Arrays.hashCode(obj.getKeystoreFile());
        result = prime * result + Objects.hashCode(obj.getName());
        result = prime * result + Objects.hashCode(obj.getSignAlg());
        result = prime * result + Objects.hashCode(obj.getStorePassword());
        result = prime * result + Objects.hashCode(obj.getValidity());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.@NonNull OdlKeystore thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.OdlKeystore.class, obj);
        return other != null
            && Objects.equals(thisObj.getKeysize(), other.getKeysize())
            && Objects.equals(thisObj.getValidity(), other.getValidity())
            && Objects.equals(thisObj.getAlias(), other.getAlias())
            && Objects.equals(thisObj.getDname(), other.getDname())
            && Objects.equals(thisObj.getKeyAlg(), other.getKeyAlg())
            && Arrays.equals(thisObj.getKeystoreFile(), other.getKeystoreFile())
            && Objects.equals(thisObj.getName(), other.getName())
            && Objects.equals(thisObj.getSignAlg(), other.getSignAlg())
            && Objects.equals(thisObj.getStorePassword(), other.getStorePassword())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.@NonNull OdlKeystore obj) {
        final var helper = MoreObjects.toStringHelper("OdlKeystore");
        CodeHelpers.appendValue(helper, "alias", obj.getAlias());
        CodeHelpers.appendValue(helper, "dname", obj.getDname());
        CodeHelpers.appendValue(helper, "keyAlg", obj.getKeyAlg());
        CodeHelpers.appendValue(helper, "keysize", obj.getKeysize());
        CodeHelpers.appendValue(helper, "keystoreFile", obj.getKeystoreFile());
        CodeHelpers.appendValue(helper, "name", obj.getName());
        CodeHelpers.appendValue(helper, "signAlg", obj.getSignAlg());
        CodeHelpers.appendValue(helper, "storePassword", obj.getStorePassword());
        CodeHelpers.appendValue(helper, "validity", obj.getValidity());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

