package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.Integer;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.Keystore;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link OdlKeystore} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     OdlKeystore createOdlKeystore(int fooXyzzy, int barBaz) {
 *         return new OdlKeystoreBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of OdlKeystore, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see OdlKeystore
 *
 */
@Generated("mdsal-binding-generator")
public class OdlKeystoreBuilder {

    private String _alias;
    private String _dname;
    private String _keyAlg;
    private Integer _keysize;
    private byte[] _keystoreFile;
    private String _name;
    private String _signAlg;
    private String _storePassword;
    private Integer _validity;


    Map<Class<? extends Augmentation<OdlKeystore>>, Augmentation<OdlKeystore>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public OdlKeystoreBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link Keystore}.
     *
     * @param arg Keystore from which the builder should be initialized
     */
    public OdlKeystoreBuilder(Keystore arg) {
        this._name = arg.getName();
        this._alias = arg.getAlias();
        this._storePassword = arg.getStorePassword();
        this._dname = arg.getDname();
        this._validity = arg.getValidity();
        this._keyAlg = arg.getKeyAlg();
        this._signAlg = arg.getSignAlg();
        this._keysize = arg.getKeysize();
        this._keystoreFile = arg.getKeystoreFile();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link OdlKeystore}.
     *
     * @param base OdlKeystore from which the builder should be initialized
     */
    public OdlKeystoreBuilder(OdlKeystore base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._alias = base.getAlias();
        this._dname = base.getDname();
        this._keyAlg = base.getKeyAlg();
        this._keysize = base.getKeysize();
        this._keystoreFile = base.getKeystoreFile();
        this._name = base.getName();
        this._signAlg = base.getSignAlg();
        this._storePassword = base.getStorePassword();
        this._validity = base.getValidity();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link Keystore}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Keystore castArg) {
            this._name = castArg.getName();
            this._alias = castArg.getAlias();
            this._storePassword = castArg.getStorePassword();
            this._dname = castArg.getDname();
            this._validity = castArg.getValidity();
            this._keyAlg = castArg.getKeyAlg();
            this._signAlg = castArg.getSignAlg();
            this._keysize = castArg.getKeysize();
            this._keystoreFile = castArg.getKeystoreFile();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[Keystore]");
    }

    private static final class LazyEmpty {
        static final @NonNull OdlKeystore INSTANCE = new OdlKeystoreBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of OdlKeystore.
     *
     * @return An empty {@link OdlKeystore}
     */
    public static @NonNull OdlKeystore empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link OdlKeystore#getAlias()}.
     *
     * @return current value
     */
    public String getAlias() {
        return _alias;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link OdlKeystore#getDname()}.
     *
     * @return current value
     */
    public String getDname() {
        return _dname;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link OdlKeystore#getKeyAlg()}.
     *
     * @return current value
     */
    public String getKeyAlg() {
        return _keyAlg;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link OdlKeystore#getKeysize()}.
     *
     * @return current value
     */
    public Integer getKeysize() {
        return _keysize;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link OdlKeystore#getKeystoreFile()}.
     *
     * @return current value
     */
    public byte[] getKeystoreFile() {
        return _keystoreFile == null ? null : _keystoreFile.clone();
    }
    
    /**
     * Return current value associated with the property corresponding to {@link OdlKeystore#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link OdlKeystore#getSignAlg()}.
     *
     * @return current value
     */
    public String getSignAlg() {
        return _signAlg;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link OdlKeystore#getStorePassword()}.
     *
     * @return current value
     */
    public String getStorePassword() {
        return _storePassword;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link OdlKeystore#getValidity()}.
     *
     * @return current value
     */
    public Integer getValidity() {
        return _validity;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<OdlKeystore>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link OdlKeystore#getAlias()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public OdlKeystoreBuilder setAlias(final String value) {
        this._alias = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link OdlKeystore#getDname()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public OdlKeystoreBuilder setDname(final String value) {
        this._dname = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link OdlKeystore#getKeyAlg()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public OdlKeystoreBuilder setKeyAlg(final String value) {
        this._keyAlg = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link OdlKeystore#getKeysize()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public OdlKeystoreBuilder setKeysize(final Integer value) {
        this._keysize = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link OdlKeystore#getKeystoreFile()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public OdlKeystoreBuilder setKeystoreFile(final byte[] value) {
        this._keystoreFile = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link OdlKeystore#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public OdlKeystoreBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link OdlKeystore#getSignAlg()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public OdlKeystoreBuilder setSignAlg(final String value) {
        this._signAlg = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link OdlKeystore#getStorePassword()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public OdlKeystoreBuilder setStorePassword(final String value) {
        this._storePassword = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link OdlKeystore#getValidity()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public OdlKeystoreBuilder setValidity(final Integer value) {
        this._validity = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public OdlKeystoreBuilder addAugmentation(Augmentation<OdlKeystore> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public OdlKeystoreBuilder removeAugmentation(Class<? extends Augmentation<OdlKeystore>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link OdlKeystore} instance.
     *
     * @return A new {@link OdlKeystore} instance.
     */
    public @NonNull OdlKeystore build() {
        return new OdlKeystoreImpl(this);
    }

    private static final class OdlKeystoreImpl
        extends AbstractAugmentable<OdlKeystore>
        implements OdlKeystore {
    
        private final String _alias;
        private final String _dname;
        private final String _keyAlg;
        private final Integer _keysize;
        private final byte[] _keystoreFile;
        private final String _name;
        private final String _signAlg;
        private final String _storePassword;
        private final Integer _validity;
    
        OdlKeystoreImpl(OdlKeystoreBuilder base) {
            super(base.augmentation);
            this._alias = base.getAlias();
            this._dname = base.getDname();
            this._keyAlg = base.getKeyAlg();
            this._keysize = base.getKeysize();
            this._keystoreFile = base.getKeystoreFile();
            this._name = base.getName();
            this._signAlg = base.getSignAlg();
            this._storePassword = base.getStorePassword();
            this._validity = base.getValidity();
        }
    
        @Override
        public String getAlias() {
            return _alias;
        }
        
        @Override
        public String getDname() {
            return _dname;
        }
        
        @Override
        public String getKeyAlg() {
            return _keyAlg;
        }
        
        @Override
        public Integer getKeysize() {
            return _keysize;
        }
        
        @Override
        public byte[] getKeystoreFile() {
            return _keystoreFile == null ? null : _keystoreFile.clone();
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public String getSignAlg() {
            return _signAlg;
        }
        
        @Override
        public String getStorePassword() {
            return _storePassword;
        }
        
        @Override
        public Integer getValidity() {
            return _validity;
        }
    
        
        
        
        
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = OdlKeystore.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return OdlKeystore.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return OdlKeystore.bindingToString(this);
        }
    }
}
