package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.CtlKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.TrustKeystore;
import org.opendaylight.yang.svc.v1.urn.opendaylight.yang.aaa.cert.rev151126.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa-cert</b>
 * <pre>
 * container aaa-cert-service-config {
 *   leaf use-config {
 *     type boolean;
 *     default false;
 *   }
 *   leaf use-mdsal {
 *     type boolean;
 *     default false;
 *   }
 *   leaf bundle-name {
 *     type string;
 *   }
 *   container ctlKeystore {
 *     leaf name {
 *       type string;
 *     }
 *     leaf alias {
 *       type string;
 *     }
 *     leaf store-password {
 *       type string;
 *     }
 *     leaf dname {
 *       type string;
 *     }
 *     leaf validity {
 *       type int32;
 *     }
 *     leaf key-alg {
 *       type string;
 *     }
 *     leaf sign-alg {
 *       type string;
 *     }
 *     leaf keysize {
 *       type int32;
 *     }
 *     leaf tls-protocols {
 *       type string;
 *     }
 *     list cipher-suites {
 *       leaf suite-name {
 *         type string;
 *       }
 *     }
 *   }
 *   container trustKeystore {
 *     leaf name {
 *       type string;
 *     }
 *     leaf store-password {
 *       type string;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link AaaCertServiceConfigBuilder}.
 * @see AaaCertServiceConfigBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaCertServiceConfig
    extends
    ChildOf<AaaCertData>,
    Augmentable<AaaCertServiceConfig>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("aaa-cert-service-config");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.AaaCertServiceConfig> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.AaaCertServiceConfig.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.@NonNull AaaCertServiceConfig obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getBundleName());
        result = prime * result + Objects.hashCode(obj.getCtlKeystore());
        result = prime * result + Objects.hashCode(obj.getTrustKeystore());
        result = prime * result + Objects.hashCode(obj.getUseConfig());
        result = prime * result + Objects.hashCode(obj.getUseMdsal());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.@NonNull AaaCertServiceConfig thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.AaaCertServiceConfig.class, obj);
        return other != null
            && Objects.equals(thisObj.getUseConfig(), other.getUseConfig())
            && Objects.equals(thisObj.getUseMdsal(), other.getUseMdsal())
            && Objects.equals(thisObj.getBundleName(), other.getBundleName())
            && Objects.equals(thisObj.getCtlKeystore(), other.getCtlKeystore())
            && Objects.equals(thisObj.getTrustKeystore(), other.getTrustKeystore())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.@NonNull AaaCertServiceConfig obj) {
        final var helper = MoreObjects.toStringHelper("AaaCertServiceConfig");
        CodeHelpers.appendValue(helper, "bundleName", obj.getBundleName());
        CodeHelpers.appendValue(helper, "ctlKeystore", obj.getCtlKeystore());
        CodeHelpers.appendValue(helper, "trustKeystore", obj.getTrustKeystore());
        CodeHelpers.appendValue(helper, "useConfig", obj.getUseConfig());
        CodeHelpers.appendValue(helper, "useMdsal", obj.getUseMdsal());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return useConfig, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Use the configuration data to create the keystores
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} useConfig, or {@code null} if it is not present.
     *
     */
    Boolean getUseConfig();
    
    /**
     * Return useConfig, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Use the configuration data to create the keystores
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} useConfig, guaranteed to be non-null.
     * @throws NoSuchElementException if useConfig is not present
     *
     */
    default @NonNull Boolean requireUseConfig() {
        return CodeHelpers.require(getUseConfig(), "useconfig");
    }
    
    /**
     * Return useMdsal, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Use Mdsal as Data store for the keystore and certificates
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} useMdsal, or {@code null} if it is not present.
     *
     */
    Boolean getUseMdsal();
    
    /**
     * Return useMdsal, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Use Mdsal as Data store for the keystore and certificates
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} useMdsal, guaranteed to be non-null.
     * @throws NoSuchElementException if useMdsal is not present
     *
     */
    default @NonNull Boolean requireUseMdsal() {
        return CodeHelpers.require(getUseMdsal(), "usemdsal");
    }
    
    /**
     * Return bundleName, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         bundle name of the default TLS config in MdsaL
     *     </code>
     * </pre>
     *
     * @return {@code String} bundleName, or {@code null} if it is not present.
     *
     */
    String getBundleName();
    
    /**
     * Return bundleName, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         bundle name of the default TLS config in MdsaL
     *     </code>
     * </pre>
     *
     * @return {@code String} bundleName, guaranteed to be non-null.
     * @throws NoSuchElementException if bundleName is not present
     *
     */
    default @NonNull String requireBundleName() {
        return CodeHelpers.require(getBundleName(), "bundlename");
    }
    
    /**
     * Return ctlKeystore, or {@code null} if it is not present.
     *
     * @return {@code CtlKeystore} ctlKeystore, or {@code null} if it is not present.
     *
     */
    CtlKeystore getCtlKeystore();
    
    /**
     * Return ctlKeystore, or an empty instance if it is not present.
     *
     * @return {@code CtlKeystore} ctlKeystore, or an empty instance if it is not present.
     *
     */
    @NonNull CtlKeystore nonnullCtlKeystore();
    
    /**
     * Return trustKeystore, or {@code null} if it is not present.
     *
     * @return {@code TrustKeystore} trustKeystore, or {@code null} if it is not present.
     *
     */
    TrustKeystore getTrustKeystore();
    
    /**
     * Return trustKeystore, or an empty instance if it is not present.
     *
     * @return {@code TrustKeystore} trustKeystore, or an empty instance if it is not present.
     *
     */
    @NonNull TrustKeystore nonnullTrustKeystore();

}

