package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.CtlKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.TrustKeystore;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link AaaCertServiceConfig} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     AaaCertServiceConfig createAaaCertServiceConfig(int fooXyzzy, int barBaz) {
 *         return new AaaCertServiceConfigBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of AaaCertServiceConfig, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see AaaCertServiceConfig
 *
 */
@Generated("mdsal-binding-generator")
public class AaaCertServiceConfigBuilder {

    private String _bundleName;
    private CtlKeystore _ctlKeystore;
    private TrustKeystore _trustKeystore;
    private Boolean _useConfig;
    private Boolean _useMdsal;


    Map<Class<? extends Augmentation<AaaCertServiceConfig>>, Augmentation<AaaCertServiceConfig>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public AaaCertServiceConfigBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link AaaCertServiceConfig}.
     *
     * @param base AaaCertServiceConfig from which the builder should be initialized
     */
    public AaaCertServiceConfigBuilder(AaaCertServiceConfig base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._bundleName = base.getBundleName();
        this._ctlKeystore = base.getCtlKeystore();
        this._trustKeystore = base.getTrustKeystore();
        this._useConfig = base.getUseConfig();
        this._useMdsal = base.getUseMdsal();
    }


    private static final class LazyEmpty {
        static final @NonNull AaaCertServiceConfig INSTANCE = new AaaCertServiceConfigBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of AaaCertServiceConfig.
     *
     * @return An empty {@link AaaCertServiceConfig}
     */
    public static @NonNull AaaCertServiceConfig empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link AaaCertServiceConfig#getBundleName()}.
     *
     * @return current value
     */
    public String getBundleName() {
        return _bundleName;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link AaaCertServiceConfig#getCtlKeystore()}.
     *
     * @return current value
     */
    public CtlKeystore getCtlKeystore() {
        return _ctlKeystore;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link AaaCertServiceConfig#getTrustKeystore()}.
     *
     * @return current value
     */
    public TrustKeystore getTrustKeystore() {
        return _trustKeystore;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link AaaCertServiceConfig#getUseConfig()}.
     *
     * @return current value
     */
    public Boolean getUseConfig() {
        return _useConfig;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link AaaCertServiceConfig#getUseMdsal()}.
     *
     * @return current value
     */
    public Boolean getUseMdsal() {
        return _useMdsal;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<AaaCertServiceConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link AaaCertServiceConfig#getBundleName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AaaCertServiceConfigBuilder setBundleName(final String value) {
        this._bundleName = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link AaaCertServiceConfig#getCtlKeystore()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AaaCertServiceConfigBuilder setCtlKeystore(final CtlKeystore value) {
        this._ctlKeystore = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link AaaCertServiceConfig#getTrustKeystore()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AaaCertServiceConfigBuilder setTrustKeystore(final TrustKeystore value) {
        this._trustKeystore = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link AaaCertServiceConfig#getUseConfig()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AaaCertServiceConfigBuilder setUseConfig(final Boolean value) {
        this._useConfig = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link AaaCertServiceConfig#getUseMdsal()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AaaCertServiceConfigBuilder setUseMdsal(final Boolean value) {
        this._useMdsal = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public AaaCertServiceConfigBuilder addAugmentation(Augmentation<AaaCertServiceConfig> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public AaaCertServiceConfigBuilder removeAugmentation(Class<? extends Augmentation<AaaCertServiceConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link AaaCertServiceConfig} instance.
     *
     * @return A new {@link AaaCertServiceConfig} instance.
     */
    public @NonNull AaaCertServiceConfig build() {
        return new AaaCertServiceConfigImpl(this);
    }

    private static final class AaaCertServiceConfigImpl
        extends AbstractAugmentable<AaaCertServiceConfig>
        implements AaaCertServiceConfig {
    
        private final String _bundleName;
        private final CtlKeystore _ctlKeystore;
        private final TrustKeystore _trustKeystore;
        private final Boolean _useConfig;
        private final Boolean _useMdsal;
    
        AaaCertServiceConfigImpl(AaaCertServiceConfigBuilder base) {
            super(base.augmentation);
            this._bundleName = base.getBundleName();
            this._ctlKeystore = base.getCtlKeystore();
            this._trustKeystore = base.getTrustKeystore();
            this._useConfig = base.getUseConfig();
            this._useMdsal = base.getUseMdsal();
        }
    
        @Override
        public String getBundleName() {
            return _bundleName;
        }
        
        @Override
        public CtlKeystore getCtlKeystore() {
            return _ctlKeystore;
        }
        
        @Override
        public TrustKeystore getTrustKeystore() {
            return _trustKeystore;
        }
        
        @Override
        public Boolean getUseConfig() {
            return _useConfig;
        }
        
        @Override
        public Boolean getUseMdsal() {
            return _useMdsal;
        }
    
        
        @Override
        public CtlKeystore nonnullCtlKeystore() {
            return Objects.requireNonNullElse(getCtlKeystore(), org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.CtlKeystoreBuilder.empty());
        }
        
        @Override
        public TrustKeystore nonnullTrustKeystore() {
            return Objects.requireNonNullElse(getTrustKeystore(), org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.TrustKeystoreBuilder.empty());
        }
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = AaaCertServiceConfig.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return AaaCertServiceConfig.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return AaaCertServiceConfig.bindingToString(this);
        }
    }
}
