package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Integer;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.AaaCertServiceConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.ctlkeystore.CipherSuites;
import org.opendaylight.yang.svc.v1.urn.opendaylight.yang.aaa.cert.rev151126.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa-cert</b>
 * <pre>
 * container ctlKeystore {
 *   leaf name {
 *     type string;
 *   }
 *   leaf alias {
 *     type string;
 *   }
 *   leaf store-password {
 *     type string;
 *   }
 *   leaf dname {
 *     type string;
 *   }
 *   leaf validity {
 *     type int32;
 *   }
 *   leaf key-alg {
 *     type string;
 *   }
 *   leaf sign-alg {
 *     type string;
 *   }
 *   leaf keysize {
 *     type int32;
 *   }
 *   leaf tls-protocols {
 *     type string;
 *   }
 *   list cipher-suites {
 *     leaf suite-name {
 *       type string;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link CtlKeystoreBuilder}.
 * @see CtlKeystoreBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface CtlKeystore
    extends
    ChildOf<AaaCertServiceConfig>,
    Augmentable<CtlKeystore>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("ctlKeystore");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.CtlKeystore> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.CtlKeystore.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.@NonNull CtlKeystore obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getAlias());
        result = prime * result + Objects.hashCode(obj.getCipherSuites());
        result = prime * result + Objects.hashCode(obj.getDname());
        result = prime * result + Objects.hashCode(obj.getKeyAlg());
        result = prime * result + Objects.hashCode(obj.getKeysize());
        result = prime * result + Objects.hashCode(obj.getName());
        result = prime * result + Objects.hashCode(obj.getSignAlg());
        result = prime * result + Objects.hashCode(obj.getStorePassword());
        result = prime * result + Objects.hashCode(obj.getTlsProtocols());
        result = prime * result + Objects.hashCode(obj.getValidity());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.@NonNull CtlKeystore thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.CtlKeystore.class, obj);
        return other != null
            && Objects.equals(thisObj.getKeysize(), other.getKeysize())
            && Objects.equals(thisObj.getValidity(), other.getValidity())
            && Objects.equals(thisObj.getAlias(), other.getAlias())
            && Objects.equals(thisObj.getDname(), other.getDname())
            && Objects.equals(thisObj.getKeyAlg(), other.getKeyAlg())
            && Objects.equals(thisObj.getName(), other.getName())
            && Objects.equals(thisObj.getSignAlg(), other.getSignAlg())
            && Objects.equals(thisObj.getStorePassword(), other.getStorePassword())
            && Objects.equals(thisObj.getTlsProtocols(), other.getTlsProtocols())
            && Objects.equals(thisObj.getCipherSuites(), other.getCipherSuites())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.@NonNull CtlKeystore obj) {
        final var helper = MoreObjects.toStringHelper("CtlKeystore");
        CodeHelpers.appendValue(helper, "alias", obj.getAlias());
        CodeHelpers.appendValue(helper, "cipherSuites", obj.getCipherSuites());
        CodeHelpers.appendValue(helper, "dname", obj.getDname());
        CodeHelpers.appendValue(helper, "keyAlg", obj.getKeyAlg());
        CodeHelpers.appendValue(helper, "keysize", obj.getKeysize());
        CodeHelpers.appendValue(helper, "name", obj.getName());
        CodeHelpers.appendValue(helper, "signAlg", obj.getSignAlg());
        CodeHelpers.appendValue(helper, "storePassword", obj.getStorePassword());
        CodeHelpers.appendValue(helper, "tlsProtocols", obj.getTlsProtocols());
        CodeHelpers.appendValue(helper, "validity", obj.getValidity());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         keystore name default is ctl
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         keystore name default is ctl
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return alias, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         key alias
     *     </code>
     * </pre>
     *
     * @return {@code String} alias, or {@code null} if it is not present.
     *
     */
    String getAlias();
    
    /**
     * Return alias, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         key alias
     *     </code>
     * </pre>
     *
     * @return {@code String} alias, guaranteed to be non-null.
     * @throws NoSuchElementException if alias is not present
     *
     */
    default @NonNull String requireAlias() {
        return CodeHelpers.require(getAlias(), "alias");
    }
    
    /**
     * Return storePassword, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         keystore password
     *     </code>
     * </pre>
     *
     * @return {@code String} storePassword, or {@code null} if it is not present.
     *
     */
    String getStorePassword();
    
    /**
     * Return storePassword, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         keystore password
     *     </code>
     * </pre>
     *
     * @return {@code String} storePassword, guaranteed to be non-null.
     * @throws NoSuchElementException if storePassword is not present
     *
     */
    default @NonNull String requireStorePassword() {
        return CodeHelpers.require(getStorePassword(), "storepassword");
    }
    
    /**
     * Return dname, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         X.500 Distinguished Names should be in the following formate CN=commonName
     *         OU=organizationUnit O=organizationName L=localityName S=stateName C=country
     *     </code>
     * </pre>
     *
     * @return {@code String} dname, or {@code null} if it is not present.
     *
     */
    String getDname();
    
    /**
     * Return dname, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         X.500 Distinguished Names should be in the following formate CN=commonName
     *         OU=organizationUnit O=organizationName L=localityName S=stateName C=country
     *     </code>
     * </pre>
     *
     * @return {@code String} dname, guaranteed to be non-null.
     * @throws NoSuchElementException if dname is not present
     *
     */
    default @NonNull String requireDname() {
        return CodeHelpers.require(getDname(), "dname");
    }
    
    /**
     * Return validity, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         validity
     *     </code>
     * </pre>
     *
     * @return {@code Integer} validity, or {@code null} if it is not present.
     *
     */
    Integer getValidity();
    
    /**
     * Return validity, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         validity
     *     </code>
     * </pre>
     *
     * @return {@code Integer} validity, guaranteed to be non-null.
     * @throws NoSuchElementException if validity is not present
     *
     */
    default @NonNull Integer requireValidity() {
        return CodeHelpers.require(getValidity(), "validity");
    }
    
    /**
     * Return keyAlg, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The supported key generation algorithms i.e: DSA or RSA
     *     </code>
     * </pre>
     *
     * @return {@code String} keyAlg, or {@code null} if it is not present.
     *
     */
    String getKeyAlg();
    
    /**
     * Return keyAlg, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The supported key generation algorithms i.e: DSA or RSA
     *     </code>
     * </pre>
     *
     * @return {@code String} keyAlg, guaranteed to be non-null.
     * @throws NoSuchElementException if keyAlg is not present
     *
     */
    default @NonNull String requireKeyAlg() {
        return CodeHelpers.require(getKeyAlg(), "keyalg");
    }
    
    /**
     * Return signAlg, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The supported sign algorithmes i.e: SHA1withDSA or SHA1withRSA
     *     </code>
     * </pre>
     *
     * @return {@code String} signAlg, or {@code null} if it is not present.
     *
     */
    String getSignAlg();
    
    /**
     * Return signAlg, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The supported sign algorithmes i.e: SHA1withDSA or SHA1withRSA
     *     </code>
     * </pre>
     *
     * @return {@code String} signAlg, guaranteed to be non-null.
     * @throws NoSuchElementException if signAlg is not present
     *
     */
    default @NonNull String requireSignAlg() {
        return CodeHelpers.require(getSignAlg(), "signalg");
    }
    
    /**
     * Return keysize, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         the key size i.e: 1024
     *     </code>
     * </pre>
     *
     * @return {@code Integer} keysize, or {@code null} if it is not present.
     *
     */
    Integer getKeysize();
    
    /**
     * Return keysize, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         the key size i.e: 1024
     *     </code>
     * </pre>
     *
     * @return {@code Integer} keysize, guaranteed to be non-null.
     * @throws NoSuchElementException if keysize is not present
     *
     */
    default @NonNull Integer requireKeysize() {
        return CodeHelpers.require(getKeysize(), "keysize");
    }
    
    /**
     * Return tlsProtocols, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         the TLS supported protocols SSLv2Hello,TLSv1.1,TLSv1.2
     *     </code>
     * </pre>
     *
     * @return {@code String} tlsProtocols, or {@code null} if it is not present.
     *
     */
    String getTlsProtocols();
    
    /**
     * Return tlsProtocols, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         the TLS supported protocols SSLv2Hello,TLSv1.1,TLSv1.2
     *     </code>
     * </pre>
     *
     * @return {@code String} tlsProtocols, guaranteed to be non-null.
     * @throws NoSuchElementException if tlsProtocols is not present
     *
     */
    default @NonNull String requireTlsProtocols() {
        return CodeHelpers.require(getTlsProtocols(), "tlsprotocols");
    }
    
    /**
     * Return cipherSuites, or {@code null} if it is not present.
     *
     * @return {@code List<CipherSuites>} cipherSuites, or {@code null} if it is not present.
     *
     */
    @Nullable List<CipherSuites> getCipherSuites();
    
    /**
     * Return cipherSuites, or an empty list if it is not present.
     *
     * @return {@code List<CipherSuites>} cipherSuites, or an empty list if it is not present.
     *
     */
    default @NonNull List<CipherSuites> nonnullCipherSuites() {
        return CodeHelpers.nonnull(getCipherSuites());
    }

}

