package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config;
import java.lang.Class;
import java.lang.Integer;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.ctlkeystore.CipherSuites;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link CtlKeystore} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     CtlKeystore createCtlKeystore(int fooXyzzy, int barBaz) {
 *         return new CtlKeystoreBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of CtlKeystore, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see CtlKeystore
 *
 */
@Generated("mdsal-binding-generator")
public class CtlKeystoreBuilder {

    private String _alias;
    private List<CipherSuites> _cipherSuites;
    private String _dname;
    private String _keyAlg;
    private Integer _keysize;
    private String _name;
    private String _signAlg;
    private String _storePassword;
    private String _tlsProtocols;
    private Integer _validity;


    Map<Class<? extends Augmentation<CtlKeystore>>, Augmentation<CtlKeystore>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public CtlKeystoreBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link CtlKeystore}.
     *
     * @param base CtlKeystore from which the builder should be initialized
     */
    public CtlKeystoreBuilder(CtlKeystore base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._alias = base.getAlias();
        this._cipherSuites = base.getCipherSuites();
        this._dname = base.getDname();
        this._keyAlg = base.getKeyAlg();
        this._keysize = base.getKeysize();
        this._name = base.getName();
        this._signAlg = base.getSignAlg();
        this._storePassword = base.getStorePassword();
        this._tlsProtocols = base.getTlsProtocols();
        this._validity = base.getValidity();
    }


    private static final class LazyEmpty {
        static final @NonNull CtlKeystore INSTANCE = new CtlKeystoreBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of CtlKeystore.
     *
     * @return An empty {@link CtlKeystore}
     */
    public static @NonNull CtlKeystore empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link CtlKeystore#getAlias()}.
     *
     * @return current value
     */
    public String getAlias() {
        return _alias;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link CtlKeystore#getCipherSuites()}.
     *
     * @return current value
     */
    public List<CipherSuites> getCipherSuites() {
        return _cipherSuites;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link CtlKeystore#getDname()}.
     *
     * @return current value
     */
    public String getDname() {
        return _dname;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link CtlKeystore#getKeyAlg()}.
     *
     * @return current value
     */
    public String getKeyAlg() {
        return _keyAlg;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link CtlKeystore#getKeysize()}.
     *
     * @return current value
     */
    public Integer getKeysize() {
        return _keysize;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link CtlKeystore#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link CtlKeystore#getSignAlg()}.
     *
     * @return current value
     */
    public String getSignAlg() {
        return _signAlg;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link CtlKeystore#getStorePassword()}.
     *
     * @return current value
     */
    public String getStorePassword() {
        return _storePassword;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link CtlKeystore#getTlsProtocols()}.
     *
     * @return current value
     */
    public String getTlsProtocols() {
        return _tlsProtocols;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link CtlKeystore#getValidity()}.
     *
     * @return current value
     */
    public Integer getValidity() {
        return _validity;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<CtlKeystore>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link CtlKeystore#getAlias()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public CtlKeystoreBuilder setAlias(final String value) {
        this._alias = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link CtlKeystore#getCipherSuites()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public CtlKeystoreBuilder setCipherSuites(final List<CipherSuites> values) {
        this._cipherSuites = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link CtlKeystore#getDname()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public CtlKeystoreBuilder setDname(final String value) {
        this._dname = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link CtlKeystore#getKeyAlg()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public CtlKeystoreBuilder setKeyAlg(final String value) {
        this._keyAlg = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link CtlKeystore#getKeysize()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public CtlKeystoreBuilder setKeysize(final Integer value) {
        this._keysize = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link CtlKeystore#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public CtlKeystoreBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link CtlKeystore#getSignAlg()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public CtlKeystoreBuilder setSignAlg(final String value) {
        this._signAlg = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link CtlKeystore#getStorePassword()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public CtlKeystoreBuilder setStorePassword(final String value) {
        this._storePassword = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link CtlKeystore#getTlsProtocols()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public CtlKeystoreBuilder setTlsProtocols(final String value) {
        this._tlsProtocols = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link CtlKeystore#getValidity()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public CtlKeystoreBuilder setValidity(final Integer value) {
        this._validity = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public CtlKeystoreBuilder addAugmentation(Augmentation<CtlKeystore> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public CtlKeystoreBuilder removeAugmentation(Class<? extends Augmentation<CtlKeystore>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link CtlKeystore} instance.
     *
     * @return A new {@link CtlKeystore} instance.
     */
    public @NonNull CtlKeystore build() {
        return new CtlKeystoreImpl(this);
    }

    private static final class CtlKeystoreImpl
        extends AbstractAugmentable<CtlKeystore>
        implements CtlKeystore {
    
        private final String _alias;
        private final List<CipherSuites> _cipherSuites;
        private final String _dname;
        private final String _keyAlg;
        private final Integer _keysize;
        private final String _name;
        private final String _signAlg;
        private final String _storePassword;
        private final String _tlsProtocols;
        private final Integer _validity;
    
        CtlKeystoreImpl(CtlKeystoreBuilder base) {
            super(base.augmentation);
            this._alias = base.getAlias();
            this._cipherSuites = CodeHelpers.emptyToNull(base.getCipherSuites());
            this._dname = base.getDname();
            this._keyAlg = base.getKeyAlg();
            this._keysize = base.getKeysize();
            this._name = base.getName();
            this._signAlg = base.getSignAlg();
            this._storePassword = base.getStorePassword();
            this._tlsProtocols = base.getTlsProtocols();
            this._validity = base.getValidity();
        }
    
        @Override
        public String getAlias() {
            return _alias;
        }
        
        @Override
        public List<CipherSuites> getCipherSuites() {
            return _cipherSuites;
        }
        
        @Override
        public String getDname() {
            return _dname;
        }
        
        @Override
        public String getKeyAlg() {
            return _keyAlg;
        }
        
        @Override
        public Integer getKeysize() {
            return _keysize;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public String getSignAlg() {
            return _signAlg;
        }
        
        @Override
        public String getStorePassword() {
            return _storePassword;
        }
        
        @Override
        public String getTlsProtocols() {
            return _tlsProtocols;
        }
        
        @Override
        public Integer getValidity() {
            return _validity;
        }
    
        
        
        
        
        
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = CtlKeystore.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return CtlKeystore.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return CtlKeystore.bindingToString(this);
        }
    }
}
