package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.Class;
import java.lang.FunctionalInterface;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Rpc;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;

/**
 * Generate a certificate request from the ODL keystore to be signed by a CA
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa-cert-rpc</b>
 * <pre>
 * rpc getODLCertificateReq {
 *   output output {
 *     leaf odl-cert-req {
 *       type string;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@FunctionalInterface
@Generated("mdsal-binding-generator")
public interface GetODLCertificateReq
    extends
    Rpc<GetODLCertificateReqInput, GetODLCertificateReqOutput>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("getODLCertificateReq");

    @Override
    ListenableFuture<RpcResult<GetODLCertificateReqOutput>> invoke(GetODLCertificateReqInput input);
    
    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetODLCertificateReq> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetODLCertificateReq.class;
    }

}

