package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.Class;
import java.lang.FunctionalInterface;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Rpc;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;

/**
 * The certificate should be generated based on a certificate request generated 
 * from the ctl.jks keystore otherwise the certificate will not be added to ctl 
 * keystore
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa-cert-rpc</b>
 * <pre>
 * rpc setODLCertificate {
 *   input input {
 *     leaf odl-cert-alias {
 *       type string;
 *     }
 *     leaf odl-cert {
 *       type string;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@FunctionalInterface
@Generated("mdsal-binding-generator")
public interface SetODLCertificate
    extends
    Rpc<SetODLCertificateInput, SetODLCertificateOutput>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("setODLCertificate");

    @Override
    ListenableFuture<RpcResult<SetODLCertificateOutput>> invoke(SetODLCertificateInput input);
    
    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.SetODLCertificate> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.SetODLCertificate.class;
    }

}

