/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cert.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.KeyStore;
import java.util.Objects;
import org.opendaylight.aaa.cert.api.IAaaCertProvider;
import org.opendaylight.aaa.cert.impl.KeyStoreConstant;
import org.opendaylight.aaa.cert.impl.ODLKeyTool;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.CtlKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.TrustKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.ctlkeystore.CipherSuites;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AaaCertProvider
implements IAaaCertProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AaaCertProvider.class);
    private final CtlKeystore ctlKeyStore;
    private final ODLKeyTool odlKeyTool = new ODLKeyTool();
    private final TrustKeystore trustKeyStore;

    public AaaCertProvider(CtlKeystore ctlKeyStore, TrustKeystore trustKeyStore) {
        this.ctlKeyStore = ctlKeyStore;
        this.trustKeyStore = trustKeyStore;
        LOG.info("aaa Certificate Service Initalized");
    }

    @Override
    public TrustKeystore getTrustKeyStoreInfo() {
        return this.trustKeyStore;
    }

    @Override
    public CtlKeystore getOdlKeyStoreInfo() {
        return this.ctlKeyStore;
    }

    @Override
    public boolean addCertificateODLKeyStore(String storePasswd, String alias, String certificate) {
        KeyStore keyStore = this.odlKeyTool.addCertificate(this.odlKeyTool.loadKeyStore(this.ctlKeyStore.getName(), storePasswd), certificate, alias, true);
        return this.odlKeyTool.exportKeystore(keyStore, storePasswd, this.ctlKeyStore.getName());
    }

    @Override
    public boolean addCertificateODLKeyStore(String alias, String certificate) {
        return this.addCertificateODLKeyStore(this.ctlKeyStore.getStorePassword(), alias, certificate);
    }

    @Override
    public boolean addCertificateTrustStore(String storePasswd, String alias, String certificate) {
        KeyStore keyStore = this.odlKeyTool.addCertificate(this.odlKeyTool.loadKeyStore(this.trustKeyStore.getName(), storePasswd), certificate, alias, true);
        return this.odlKeyTool.exportKeystore(keyStore, storePasswd, this.trustKeyStore.getName());
    }

    @Override
    public boolean addCertificateTrustStore(String alias, String certificate) {
        return this.addCertificateTrustStore(this.trustKeyStore.getStorePassword(), alias, certificate);
    }

    @Override
    public boolean createKeyStores() {
        KeyStore keyStore;
        if (!KeyStoreConstant.checkKeyStoreFile(this.ctlKeyStore.getName()) && !this.odlKeyTool.exportKeystore(keyStore = this.odlKeyTool.createKeyStoreWithSelfSignCert(this.ctlKeyStore.getName(), this.ctlKeyStore.getStorePassword(), this.ctlKeyStore.getDname(), this.ctlKeyStore.getAlias(), this.ctlKeyStore.getValidity(), this.ctlKeyStore.getKeyAlg(), this.ctlKeyStore.getKeysize(), this.ctlKeyStore.getSignAlg()), this.ctlKeyStore.getStorePassword(), this.ctlKeyStore.getName())) {
            return false;
        }
        return KeyStoreConstant.checkKeyStoreFile(this.trustKeyStore.getName()) || this.odlKeyTool.exportKeystore(keyStore = this.odlKeyTool.createEmptyKeyStore(this.trustKeyStore.getStorePassword()), this.trustKeyStore.getStorePassword(), this.trustKeyStore.getName());
    }

    @Override
    public String genODLKeyStoreCertificateReq(String storePasswd, boolean withTag) {
        return this.odlKeyTool.generateCertificateReq(this.odlKeyTool.loadKeyStore(this.ctlKeyStore.getName(), storePasswd), storePasswd, this.ctlKeyStore.getAlias(), this.ctlKeyStore.getSignAlg(), withTag);
    }

    @Override
    public String genODLKeyStoreCertificateReq(boolean withTag) {
        return this.genODLKeyStoreCertificateReq(this.ctlKeyStore.getStorePassword(), withTag);
    }

    @Override
    public String getCertificateTrustStore(String storePasswd, String aliase, boolean withTag) {
        return this.odlKeyTool.getCertificate(this.odlKeyTool.loadKeyStore(this.trustKeyStore.getName(), storePasswd), aliase, withTag);
    }

    @Override
    public String getCertificateTrustStore(String aliase, boolean withTag) {
        return this.getCertificateTrustStore(this.trustKeyStore.getStorePassword(), aliase, withTag);
    }

    @Override
    public String getODLKeyStoreCertificate(String storePasswd, boolean withTag) {
        return this.odlKeyTool.getCertificate(this.odlKeyTool.loadKeyStore(this.ctlKeyStore.getName(), storePasswd), this.ctlKeyStore.getAlias(), withTag);
    }

    @Override
    public String getODLKeyStoreCertificate(boolean withTag) {
        return this.getODLKeyStoreCertificate(this.ctlKeyStore.getStorePassword(), withTag);
    }

    @Override
    public KeyStore getODLKeyStore() {
        return this.odlKeyTool.loadKeyStore(this.ctlKeyStore.getName(), this.ctlKeyStore.getStorePassword());
    }

    @Override
    public KeyStore getTrustKeyStore() {
        return this.odlKeyTool.loadKeyStore(this.trustKeyStore.getName(), this.trustKeyStore.getStorePassword());
    }

    @Override
    public String[] getCipherSuites() {
        return (String[])this.ctlKeyStore.nonnullCipherSuites().stream().map(CipherSuites::getSuiteName).filter(name -> !name.isEmpty()).toArray(String[]::new);
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public String[] getTlsProtocols() {
        String[] stringArray;
        String tlsProtocols = Objects.requireNonNullElse(this.ctlKeyStore.getTlsProtocols(), "").replace(" ", "");
        if (tlsProtocols.isEmpty()) {
            return null;
        }
        if (tlsProtocols.contains(",")) {
            stringArray = tlsProtocols.split(",");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = tlsProtocols;
        }
        return stringArray;
    }
}

