/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cert.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.aaa.cert.api.IAaaCertProvider;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetNodeCertificateInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetNodeCertificateOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetNodeCertificateOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetODLCertificateInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetODLCertificateOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetODLCertificateOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetODLCertificateReqInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetODLCertificateReqOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.GetODLCertificateReqOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.SetNodeCertificateInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.SetNodeCertificateOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.SetNodeCertificateOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.SetODLCertificateInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.SetODLCertificateOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rpc.rev151215.SetODLCertificateOutputBuilder;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.Rpc;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AaaCertRpcServiceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(AaaCertRpcServiceImpl.class);
    private final IAaaCertProvider aaaCertProvider;

    AaaCertRpcServiceImpl(@NonNull IAaaCertProvider aaaCertProvider) {
        this.aaaCertProvider = Objects.requireNonNull(aaaCertProvider);
    }

    @NonNull Registration registerWith(RpcProviderService rpcProviderService) {
        return rpcProviderService.registerRpcImplementations(new Rpc[]{this::getNodeCertificate, this::setNodeCertificate, this::getODLCertificate, this::setODLCertificate, this::getODLCertificateReq});
    }

    @VisibleForTesting
    ListenableFuture<RpcResult<GetNodeCertificateOutput>> getNodeCertificate(GetNodeCertificateInput input) {
        String cert = this.aaaCertProvider.getCertificateTrustStore(input.getNodeAlias(), false);
        if (Strings.isNullOrEmpty((String)cert)) {
            return RpcResultBuilder.failed().withRpcError(RpcResultBuilder.newError((ErrorType)ErrorType.APPLICATION, (ErrorTag)ErrorTag.DATA_MISSING, (String)("getNodeCertificate does not fetch certificate for the alias " + input.getNodeAlias()))).buildFuture();
        }
        return RpcResultBuilder.success((Object)new GetNodeCertificateOutputBuilder().setNodeCert(cert).build()).buildFuture();
    }

    @VisibleForTesting
    ListenableFuture<RpcResult<SetODLCertificateOutput>> setODLCertificate(SetODLCertificateInput input) {
        if (this.aaaCertProvider.addCertificateODLKeyStore(input.getOdlCertAlias(), input.getOdlCert())) {
            return RpcResultBuilder.success((Object)new SetODLCertificateOutputBuilder().build()).buildFuture();
        }
        LOG.info("Error while adding ODL certificate");
        return RpcResultBuilder.failed().buildFuture();
    }

    @VisibleForTesting
    ListenableFuture<RpcResult<GetODLCertificateOutput>> getODLCertificate(GetODLCertificateInput input) {
        String cert = this.aaaCertProvider.getODLKeyStoreCertificate(false);
        if (Strings.isNullOrEmpty((String)cert)) {
            return RpcResultBuilder.failed().buildFuture();
        }
        return RpcResultBuilder.success((Object)new GetODLCertificateOutputBuilder().setOdlCert(cert).build()).buildFuture();
    }

    @VisibleForTesting
    ListenableFuture<RpcResult<GetODLCertificateReqOutput>> getODLCertificateReq(GetODLCertificateReqInput input) {
        String certReq = this.aaaCertProvider.genODLKeyStoreCertificateReq(false);
        if (Strings.isNullOrEmpty((String)certReq)) {
            return RpcResultBuilder.failed().buildFuture();
        }
        return RpcResultBuilder.success((Object)new GetODLCertificateReqOutputBuilder().setOdlCertReq(certReq).build()).buildFuture();
    }

    @VisibleForTesting
    ListenableFuture<RpcResult<SetNodeCertificateOutput>> setNodeCertificate(SetNodeCertificateInput input) {
        if (this.aaaCertProvider.addCertificateTrustStore(input.getNodeAlias(), input.getNodeCert())) {
            return RpcResultBuilder.success((Object)new SetNodeCertificateOutputBuilder().build()).buildFuture();
        }
        LOG.info("Error while adding the Node certificate");
        return RpcResultBuilder.failed().buildFuture();
    }
}

