/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cert.impl;

import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.RandomStringUtils;
import org.opendaylight.aaa.cert.api.IAaaCertProvider;
import org.opendaylight.aaa.cert.api.ICertificateManager;
import org.opendaylight.aaa.cert.impl.AaaCertMdsalProvider;
import org.opendaylight.aaa.cert.impl.AaaCertProvider;
import org.opendaylight.aaa.cert.impl.AaaCertRpcServiceImpl;
import org.opendaylight.aaa.cert.impl.DefaultMdsalSslData;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.AaaCertServiceConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.AaaCertServiceConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.CtlKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.CtlKeystoreBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.TrustKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.TrustKeystoreBuilder;
import org.opendaylight.yangtools.concepts.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CertificateManagerService
implements ICertificateManager,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateManagerService.class);
    private static final String DEFAULT_CONFIG_FILE_PATH = "etc" + File.separator + "opendaylight" + File.separator + "datastore" + File.separator + "initial" + File.separator + "config" + File.separator + "aaa-cert-config.xml";
    private static final int PWD_LENGTH = 12;
    private final IAaaCertProvider aaaCertProvider;
    private final Registration reg;

    public CertificateManagerService(RpcProviderService rpcProviderService, DataBroker dataBroker, AAAEncryptionService encryptionSrv, AaaCertServiceConfig aaaCertServiceConfig) {
        if (aaaCertServiceConfig == null) {
            throw new IllegalArgumentException("Certificate Manager service configuration is null");
        }
        if (aaaCertServiceConfig.getUseConfig().booleanValue()) {
            if (aaaCertServiceConfig.getCtlKeystore() != null && aaaCertServiceConfig.getCtlKeystore().getStorePassword() != null && aaaCertServiceConfig.getCtlKeystore().getStorePassword().isEmpty()) {
                LOG.debug("Set keystores password");
                String ctlPwd = RandomStringUtils.random((int)12, (boolean)true, (boolean)true);
                String trustPwd = RandomStringUtils.random((int)12, (boolean)true, (boolean)true);
                CertificateManagerService.updateCertManagerSrvConfig(ctlPwd, trustPwd);
                CtlKeystore ctlKeystore = new CtlKeystoreBuilder(aaaCertServiceConfig.getCtlKeystore()).setStorePassword(ctlPwd).build();
                TrustKeystore trustKeystore = new TrustKeystoreBuilder(aaaCertServiceConfig.getTrustKeystore()).setStorePassword(trustPwd).build();
                aaaCertServiceConfig = new AaaCertServiceConfigBuilder(aaaCertServiceConfig).setCtlKeystore(ctlKeystore).setTrustKeystore(trustKeystore).build();
            }
            if (aaaCertServiceConfig.getUseMdsal().booleanValue()) {
                this.aaaCertProvider = new DefaultMdsalSslData(new AaaCertMdsalProvider(dataBroker, encryptionSrv), aaaCertServiceConfig.getBundleName(), aaaCertServiceConfig.getCtlKeystore(), aaaCertServiceConfig.getTrustKeystore());
                LOG.debug("Using default mdsal SslData as aaaCertProvider");
            } else {
                this.aaaCertProvider = new AaaCertProvider(aaaCertServiceConfig.getCtlKeystore(), aaaCertServiceConfig.getTrustKeystore());
                LOG.debug("Using default keystore files as aaaCertProvider");
            }
            this.aaaCertProvider.createKeyStores();
            LOG.info("Certificate Manager service has been initialized");
            this.reg = new AaaCertRpcServiceImpl(this.aaaCertProvider).registerWith(rpcProviderService);
            LOG.info("AaaCert Rpc Service has been initialized");
        } else {
            this.aaaCertProvider = null;
            this.reg = null;
            LOG.info("Certificate Manager service has not been initialized, change the initial aaa-cert-config data and restart Opendaylight");
        }
    }

    @Override
    public void close() {
        if (this.reg != null) {
            this.reg.close();
        }
    }

    @Override
    public KeyStore getODLKeyStore() {
        return this.aaaCertProvider.getODLKeyStore();
    }

    @Override
    public KeyStore getTrustKeyStore() {
        return this.aaaCertProvider.getTrustKeyStore();
    }

    @Override
    public String[] getCipherSuites() {
        return this.aaaCertProvider.getCipherSuites();
    }

    @Override
    public String getCertificateTrustStore(String storePasswd, String alias, boolean withTag) {
        return this.aaaCertProvider.getCertificateTrustStore(storePasswd, alias, withTag);
    }

    @Override
    public String getODLKeyStoreCertificate(String storePasswd, boolean withTag) {
        return this.aaaCertProvider.getODLKeyStoreCertificate(storePasswd, withTag);
    }

    @Override
    public String genODLKeyStoreCertificateReq(String storePasswd, boolean withTag) {
        return this.aaaCertProvider.genODLKeyStoreCertificateReq(storePasswd, withTag);
    }

    @Override
    public SSLContext getServerContext() {
        SSLContext serverContext = null;
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(this.aaaCertProvider.getODLKeyStore(), this.aaaCertProvider.getOdlKeyStoreInfo().getStorePassword().toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(this.aaaCertProvider.getTrustKeyStore());
            serverContext = SSLContext.getInstance("TLS");
            serverContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            LOG.error("Error while creating SSLContext ", (Throwable)e);
        }
        return serverContext;
    }

    @Override
    public String[] getTlsProtocols() {
        return this.aaaCertProvider.getTlsProtocols();
    }

    @Override
    public boolean importSslDataKeystores(String odlKeystoreName, String odlKeystorePwd, String odlKeystoreAlias, String trustKeystoreName, String trustKeystorePwd, String[] cipherSuites, String tlsProtocols) {
        DefaultMdsalSslData mdsalCertProvider = (DefaultMdsalSslData)this.aaaCertProvider;
        if (mdsalCertProvider == null) {
            LOG.debug("aaaCertProvider is not MD-Sal Certificate Provider");
            return false;
        }
        return mdsalCertProvider.importSslDataKeystores(odlKeystoreName, odlKeystorePwd, odlKeystoreAlias, trustKeystoreName, trustKeystorePwd, cipherSuites, tlsProtocols);
    }

    @Override
    public void exportSslDataKeystores() {
        DefaultMdsalSslData mdsalCertProvider = (DefaultMdsalSslData)this.aaaCertProvider;
        if (mdsalCertProvider == null) {
            LOG.debug("aaaCertProvider is not MD-Sal Certificate Provider");
            return;
        }
        mdsalCertProvider.exportSslDataKeystores();
    }

    private static void updateCertManagerSrvConfig(String ctlPwd, String trustPwd) {
        try {
            LOG.debug("Update Certificate manager service config file");
            File configFile = new File(DEFAULT_CONFIG_FILE_PATH);
            if (configFile.exists()) {
                String storePwdTag = "store-password";
                String ctlStoreTag = "ctlKeystore";
                String trustStoreTag = "trustKeystore";
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.parse(configFile);
                NodeList ndList = doc.getElementsByTagName("store-password");
                for (int i = 0; i < ndList.getLength(); ++i) {
                    Node nd = ndList.item(i);
                    if (nd.getParentNode() != null && nd.getParentNode().getNodeName().equals("ctlKeystore")) {
                        nd.setTextContent(ctlPwd);
                        continue;
                    }
                    if (nd.getParentNode() == null || !nd.getParentNode().getNodeName().equals("trustKeystore")) continue;
                    nd.setTextContent(trustPwd);
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(new File(DEFAULT_CONFIG_FILE_PATH));
                transformer.transform(source, result);
            } else {
                LOG.warn("The Certificate manager service config file does not exist {}", (Object)DEFAULT_CONFIG_FILE_PATH);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            LOG.error("Error while updating Certificate manager service config file", (Throwable)e);
        }
    }
}

