/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cert.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyStoreConstant {
    public static final String KEY_STORE_PATH = "configuration" + File.separator + "ssl" + File.separator;
    public static final String DEFAULT_KEY_ALG = "RSA";
    public static final int DEFAULT_KEY_SIZE = 2048;
    public static final String DEFAULT_SIGN_ALG = "SHA1WithRSAEncryption";
    public static final int DEFAULT_VALIDITY = 365;
    static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    static final String BEGIN_CERTIFICATE_REQUEST = "-----BEGIN CERTIFICATE REQUEST-----";
    static final String END_CERTIFICATE_REQUEST = "-----END CERTIFICATE REQUEST-----";
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreConstant.class);

    private KeyStoreConstant() {
    }

    public static File toAbsoluteFile(String fileName, String basePath) {
        File file = new File(fileName);
        return file.isAbsolute() ? file : new File(basePath + fileName);
    }

    public static boolean checkKeyStoreFile(String fileName) {
        return KeyStoreConstant.toAbsoluteFile(fileName, KEY_STORE_PATH).exists();
    }

    public static String createDir(String dir) {
        File file = new File(dir);
        if (!file.exists() && !file.mkdirs()) {
            LOG.error("Failed to create directories {}", (Object)file);
        }
        return file.getAbsolutePath();
    }

    public static String readFile(String certFile) {
        if (certFile != null && !certFile.isEmpty()) {
            Path path = KeyStoreConstant.toAbsoluteFile(certFile, KEY_STORE_PATH).toPath();
            try {
                return Files.readString(path);
            }
            catch (IOException e) {
                LOG.info("Failed to read {}", (Object)path, (Object)e);
            }
        }
        return null;
    }

    public static boolean saveCert(String fileName, String cert) {
        if (fileName != null && !fileName.isEmpty()) {
            Path path = KeyStoreConstant.toAbsoluteFile(fileName, KEY_STORE_PATH).toPath();
            try {
                Files.writeString(path, (CharSequence)cert, new OpenOption[0]);
                return true;
            }
            catch (IOException e) {
                LOG.info("Failed to write {}", (Object)path, (Object)e);
            }
        }
        return false;
    }
}

