/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cert.impl;

import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.List;
import org.opendaylight.aaa.cert.impl.MdsalUtils;
import org.opendaylight.aaa.cert.impl.ODLKeyTool;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.KeyStores;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.cipher.suite.CipherSuites;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.cipher.suite.CipherSuitesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslDataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslDataKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.OdlKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.OdlKeystoreBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.TrustKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.TrustKeystoreBuilder;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoresDataUtils {
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoresDataUtils.class);
    public static final String KEYSTORES_DATA_TREE = "KeyStores:1";
    private final AAAEncryptionService encryService;

    public KeyStoresDataUtils(AAAEncryptionService encryService) {
        this.encryService = encryService;
    }

    public static InstanceIdentifier<KeyStores> getKeystoresIid() {
        return InstanceIdentifier.builder(KeyStores.class).build();
    }

    public static InstanceIdentifier<SslData> getSslDataIid() {
        return InstanceIdentifier.create(KeyStores.class).child(SslData.class);
    }

    public static InstanceIdentifier<SslData> getSslDataIid(String bundleName) {
        SslDataKey sslDataKey = new SslDataKey(bundleName);
        return InstanceIdentifier.create(KeyStores.class).child(SslData.class, (Key)sslDataKey);
    }

    public static OdlKeystore updateOdlKeystore(OdlKeystore baseOdlKeyStore, byte[] keyStoreBytes) {
        return new OdlKeystoreBuilder(baseOdlKeyStore).setKeystoreFile(keyStoreBytes).build();
    }

    public SslData addSslData(DataBroker dataBroker, String bundleName, OdlKeystore odlKeystore, TrustKeystore trustKeystore, List<CipherSuites> cipherSuites, String tlsProtocols) {
        SslData sslData;
        SslDataKey sslDataKey = new SslDataKey(bundleName);
        try {
            sslData = new SslDataBuilder().withKey(sslDataKey).setOdlKeystore(this.encryptOdlKeyStore(odlKeystore)).setTrustKeystore(this.encryptTrustKeystore(trustKeystore)).setCipherSuites(cipherSuites).setTlsProtocols(tlsProtocols).build();
        }
        catch (GeneralSecurityException e) {
            LOG.error("Encryption of TrustKeystore for SslData failed.", (Throwable)e);
            return null;
        }
        if (MdsalUtils.put(dataBroker, LogicalDatastoreType.CONFIGURATION, KeyStoresDataUtils.getSslDataIid(bundleName), sslData)) {
            return new SslDataBuilder().withKey(sslDataKey).setOdlKeystore(odlKeystore).setTrustKeystore(trustKeystore).setCipherSuites(cipherSuites).build();
        }
        return null;
    }

    public CipherSuites createCipherSuite(String suiteName) {
        return new CipherSuitesBuilder().setSuiteName(suiteName).build();
    }

    public OdlKeystore createOdlKeystore(String name, String alias, String password, byte[] keyStoreBytes) {
        return new OdlKeystoreBuilder().setKeystoreFile(keyStoreBytes).setAlias(alias).setName(name).setStorePassword(password).build();
    }

    public OdlKeystore createOdlKeystore(String name, String alias, String password, String dname, ODLKeyTool odlKeyTool) {
        return this.createOdlKeystore(name, alias, password, dname, "SHA1WithRSAEncryption", "RSA", 365, 2048, odlKeyTool);
    }

    public OdlKeystore createOdlKeystore(String name, String alias, String password, String dname, String sigAlg, String keyAlg, int validity, int keySize, ODLKeyTool odlKeyTool) {
        byte[] keyStoreBytes = odlKeyTool.convertKeystoreToBytes(odlKeyTool.createKeyStoreWithSelfSignCert(name, password, dname, alias, validity, keyAlg, keySize, sigAlg), password);
        LOG.debug("Odl keystore string {} ", (Object)keyStoreBytes);
        return new OdlKeystoreBuilder().setKeystoreFile(keyStoreBytes).setAlias(alias).setDname(dname).setKeyAlg(keyAlg).setKeysize(keySize).setName(name).setSignAlg(sigAlg).setStorePassword(password).setValidity(validity).build();
    }

    public TrustKeystore createTrustKeystore(String name, String password, byte[] keyStoreBytes) {
        return new TrustKeystoreBuilder().setKeystoreFile(keyStoreBytes).setName(name).setStorePassword(password).build();
    }

    public TrustKeystore createTrustKeystore(String name, String password, ODLKeyTool odlKeyTool) {
        byte[] keyStoreBytes = odlKeyTool.convertKeystoreToBytes(odlKeyTool.createEmptyKeyStore(password), password);
        LOG.debug("trust keystore string {} ", (Object)keyStoreBytes);
        return new TrustKeystoreBuilder().setKeystoreFile(keyStoreBytes).setName(name).setStorePassword(password).build();
    }

    private OdlKeystore decryptOdlKeyStore(OdlKeystore odlKeystore) throws GeneralSecurityException {
        return odlKeystore == null ? null : new OdlKeystoreBuilder(odlKeystore).setKeystoreFile(this.decryptNullable(odlKeystore.getKeystoreFile())).setStorePassword(this.decryptStringFromBase64(odlKeystore.getStorePassword())).build();
    }

    private SslData decryptSslData(SslData sslData) throws GeneralSecurityException {
        return sslData == null ? null : new SslDataBuilder(sslData).setOdlKeystore(this.decryptOdlKeyStore(sslData.getOdlKeystore())).setTrustKeystore(this.decryptTrustKeystore(sslData.getTrustKeystore())).build();
    }

    private TrustKeystore decryptTrustKeystore(TrustKeystore trustKeyStore) throws GeneralSecurityException {
        return trustKeyStore == null ? null : new TrustKeystoreBuilder(trustKeyStore).setKeystoreFile(this.decryptNullable(trustKeyStore.getKeystoreFile())).setStorePassword(this.decryptStringFromBase64(trustKeyStore.getStorePassword())).build();
    }

    private byte[] decryptNullable(byte[] bytes) throws GeneralSecurityException {
        return bytes == null ? null : this.encryService.decrypt(bytes);
    }

    private String decryptStringFromBase64(String base64) throws GeneralSecurityException {
        return base64 == null ? null : new String(this.encryService.decrypt(Base64.getDecoder().decode(base64)), Charset.defaultCharset());
    }

    private String encryptStringToBase64(String str) throws GeneralSecurityException {
        return str == null ? null : Base64.getEncoder().encodeToString(this.encryService.encrypt(str.getBytes(Charset.defaultCharset())));
    }

    private OdlKeystore encryptOdlKeyStore(OdlKeystore odlKeystore) throws GeneralSecurityException {
        return new OdlKeystoreBuilder(odlKeystore).setKeystoreFile(this.encryService.encrypt(odlKeystore.getKeystoreFile())).setStorePassword(this.encryptStringToBase64(odlKeystore.getStorePassword())).build();
    }

    private SslData encryptSslData(SslData sslData) throws GeneralSecurityException {
        return new SslDataBuilder(sslData).setOdlKeystore(this.encryptOdlKeyStore(sslData.getOdlKeystore())).setTrustKeystore(this.encryptTrustKeystore(sslData.getTrustKeystore())).build();
    }

    private TrustKeystore encryptTrustKeystore(TrustKeystore trustKeyStore) throws GeneralSecurityException {
        return new TrustKeystoreBuilder(trustKeyStore).setKeystoreFile(this.encryService.encrypt(trustKeyStore.getKeystoreFile())).setStorePassword(this.encryptStringToBase64(trustKeyStore.getStorePassword())).build();
    }

    public SslData getSslData(DataBroker dataBroker, String bundleName) {
        InstanceIdentifier<SslData> sslDataIid = KeyStoresDataUtils.getSslDataIid(bundleName);
        try {
            return this.decryptSslData(MdsalUtils.read(dataBroker, LogicalDatastoreType.CONFIGURATION, sslDataIid));
        }
        catch (GeneralSecurityException e) {
            LOG.error("Decryption of KeyStore for SslData failed.", (Throwable)e);
            return null;
        }
    }

    public boolean removeSslData(DataBroker dataBroker, String bundleName) {
        InstanceIdentifier<SslData> sslDataIid = KeyStoresDataUtils.getSslDataIid(bundleName);
        return MdsalUtils.delete(dataBroker, LogicalDatastoreType.CONFIGURATION, sslDataIid);
    }

    public boolean updateSslData(DataBroker dataBroker, SslData sslData) {
        SslData encryptedSslData;
        InstanceIdentifier<SslData> sslDataIid = KeyStoresDataUtils.getSslDataIid(sslData.getBundleName());
        try {
            encryptedSslData = this.encryptSslData(sslData);
        }
        catch (GeneralSecurityException e) {
            LOG.error("Encryption of KeyStore for SslData failed.", (Throwable)e);
            return false;
        }
        return MdsalUtils.merge(dataBroker, LogicalDatastoreType.CONFIGURATION, sslDataIid, encryptedSslData);
    }

    public boolean updateSslDataCipherSuites(DataBroker dataBroker, SslData baseSslData, List<CipherSuites> cipherSuites) {
        return this.updateSslData(dataBroker, new SslDataBuilder(baseSslData).setCipherSuites(cipherSuites).build());
    }

    public boolean updateSslDataOdlKeystore(DataBroker dataBroker, SslData baseSslData, OdlKeystore odlKeyStore) {
        return this.updateSslData(dataBroker, new SslDataBuilder(baseSslData).setOdlKeystore(odlKeyStore).build());
    }

    public boolean updateSslDataTrustKeystore(DataBroker dataBroker, SslData baseSslData, TrustKeystore trustKeyStore) {
        return this.updateSslData(dataBroker, new SslDataBuilder(baseSslData).setTrustKeystore(trustKeyStore).build());
    }

    public TrustKeystore updateTrustKeystore(TrustKeystore baseTrustKeyStore, byte[] keyStoreBytes) {
        return new TrustKeystoreBuilder(baseTrustKeyStore).setKeystoreFile(keyStoreBytes).build();
    }
}

