/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.CipherSuite;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.SslData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.cipher.suite.CipherSuites;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslDataKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.OdlKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.OdlKeystoreBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.TrustKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.TrustKeystoreBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SslDataBuilder {
    private String _bundleName;
    private List<CipherSuites> _cipherSuites;
    private OdlKeystore _odlKeystore;
    private String _tlsProtocols;
    private TrustKeystore _trustKeystore;
    private SslDataKey key;
    Map<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData>> augmentation = Map.of();

    public SslDataBuilder() {
    }

    public SslDataBuilder(SslData arg) {
        this._bundleName = arg.getBundleName();
        this._tlsProtocols = arg.getTlsProtocols();
        this._odlKeystore = arg.getOdlKeystore();
        this._trustKeystore = arg.getTrustKeystore();
        this._cipherSuites = arg.getCipherSuites();
    }

    public SslDataBuilder(CipherSuite arg) {
        this._cipherSuites = arg.getCipherSuites();
    }

    public SslDataBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData>>(aug);
        }
        this.key = base.key();
        this._bundleName = base.getBundleName();
        this._cipherSuites = base.getCipherSuites();
        this._odlKeystore = base.getOdlKeystore();
        this._tlsProtocols = base.getTlsProtocols();
        this._trustKeystore = base.getTrustKeystore();
    }

    public void fieldsFrom(DataObject arg) {
        CipherSuite castArg;
        boolean isValidArg = false;
        if (arg instanceof CipherSuite) {
            castArg = (CipherSuite)arg;
            this._cipherSuites = castArg.getCipherSuites();
            isValidArg = true;
        }
        if (arg instanceof SslData) {
            castArg = (SslData)arg;
            this._bundleName = castArg.getBundleName();
            this._tlsProtocols = castArg.getTlsProtocols();
            this._odlKeystore = castArg.getOdlKeystore();
            this._trustKeystore = castArg.getTrustKeystore();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[CipherSuite, org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.SslData]");
    }

    public SslDataKey key() {
        return this.key;
    }

    public String getBundleName() {
        return this._bundleName;
    }

    public List<CipherSuites> getCipherSuites() {
        return this._cipherSuites;
    }

    public OdlKeystore getOdlKeystore() {
        return this._odlKeystore;
    }

    public String getTlsProtocols() {
        return this._tlsProtocols;
    }

    public TrustKeystore getTrustKeystore() {
        return this._trustKeystore;
    }

    public <E$$ extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public SslDataBuilder withKey(SslDataKey key) {
        this.key = key;
        return this;
    }

    public SslDataBuilder setBundleName(String value) {
        this._bundleName = value;
        return this;
    }

    public SslDataBuilder setCipherSuites(List<CipherSuites> values) {
        this._cipherSuites = values;
        return this;
    }

    public SslDataBuilder setOdlKeystore(OdlKeystore value) {
        this._odlKeystore = value;
        return this;
    }

    public SslDataBuilder setTlsProtocols(String value) {
        this._tlsProtocols = value;
        return this;
    }

    public SslDataBuilder setTrustKeystore(TrustKeystore value) {
        this._trustKeystore = value;
        return this;
    }

    public SslDataBuilder addAugmentation(Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public SslDataBuilder removeAugmentation(Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData build() {
        return new SslDataImpl(this);
    }

    private static final class SslDataImpl
    extends AbstractAugmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData>
    implements org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData {
        private final String _bundleName;
        private final List<CipherSuites> _cipherSuites;
        private final OdlKeystore _odlKeystore;
        private final String _tlsProtocols;
        private final TrustKeystore _trustKeystore;
        private final SslDataKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        SslDataImpl(SslDataBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new SslDataKey(base.getBundleName());
            this._bundleName = this.key.getBundleName();
            this._cipherSuites = CodeHelpers.emptyToNull(base.getCipherSuites());
            this._odlKeystore = base.getOdlKeystore();
            this._tlsProtocols = base.getTlsProtocols();
            this._trustKeystore = base.getTrustKeystore();
        }

        @Override
        public SslDataKey key() {
            return this.key;
        }

        @Override
        public String getBundleName() {
            return this._bundleName;
        }

        @Override
        public List<CipherSuites> getCipherSuites() {
            return this._cipherSuites;
        }

        @Override
        public OdlKeystore getOdlKeystore() {
            return this._odlKeystore;
        }

        @Override
        public String getTlsProtocols() {
            return this._tlsProtocols;
        }

        @Override
        public TrustKeystore getTrustKeystore() {
            return this._trustKeystore;
        }

        @Override
        public OdlKeystore nonnullOdlKeystore() {
            return Objects.requireNonNullElse(this.getOdlKeystore(), OdlKeystoreBuilder.empty());
        }

        @Override
        public TrustKeystore nonnullTrustKeystore() {
            return Objects.requireNonNullElse(this.getTrustKeystore(), TrustKeystoreBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData.bindingEquals(this, obj);
        }

        public String toString() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.key.stores.SslData.bindingToString(this);
        }
    }
}

