/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.Keystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.TrustKeystore;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TrustKeystoreBuilder {
    private String _alias;
    private String _dname;
    private String _keyAlg;
    private Integer _keysize;
    private byte[] _keystoreFile;
    private String _name;
    private String _signAlg;
    private String _storePassword;
    private Integer _validity;
    Map<Class<? extends Augmentation<TrustKeystore>>, Augmentation<TrustKeystore>> augmentation = Map.of();

    public TrustKeystoreBuilder() {
    }

    public TrustKeystoreBuilder(Keystore arg) {
        this._name = arg.getName();
        this._alias = arg.getAlias();
        this._storePassword = arg.getStorePassword();
        this._dname = arg.getDname();
        this._validity = arg.getValidity();
        this._keyAlg = arg.getKeyAlg();
        this._signAlg = arg.getSignAlg();
        this._keysize = arg.getKeysize();
        this._keystoreFile = arg.getKeystoreFile();
    }

    public TrustKeystoreBuilder(TrustKeystore base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TrustKeystore>>, Augmentation<TrustKeystore>>(aug);
        }
        this._alias = base.getAlias();
        this._dname = base.getDname();
        this._keyAlg = base.getKeyAlg();
        this._keysize = base.getKeysize();
        this._keystoreFile = base.getKeystoreFile();
        this._name = base.getName();
        this._signAlg = base.getSignAlg();
        this._storePassword = base.getStorePassword();
        this._validity = base.getValidity();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Keystore) {
            Keystore castArg = (Keystore)arg;
            this._name = castArg.getName();
            this._alias = castArg.getAlias();
            this._storePassword = castArg.getStorePassword();
            this._dname = castArg.getDname();
            this._validity = castArg.getValidity();
            this._keyAlg = castArg.getKeyAlg();
            this._signAlg = castArg.getSignAlg();
            this._keysize = castArg.getKeysize();
            this._keystoreFile = castArg.getKeystoreFile();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[Keystore]");
    }

    public static @NonNull TrustKeystore empty() {
        return LazyEmpty.INSTANCE;
    }

    public String getAlias() {
        return this._alias;
    }

    public String getDname() {
        return this._dname;
    }

    public String getKeyAlg() {
        return this._keyAlg;
    }

    public Integer getKeysize() {
        return this._keysize;
    }

    public byte[] getKeystoreFile() {
        return this._keystoreFile == null ? null : (byte[])this._keystoreFile.clone();
    }

    public String getName() {
        return this._name;
    }

    public String getSignAlg() {
        return this._signAlg;
    }

    public String getStorePassword() {
        return this._storePassword;
    }

    public Integer getValidity() {
        return this._validity;
    }

    public <E$$ extends Augmentation<TrustKeystore>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public TrustKeystoreBuilder setAlias(String value) {
        this._alias = value;
        return this;
    }

    public TrustKeystoreBuilder setDname(String value) {
        this._dname = value;
        return this;
    }

    public TrustKeystoreBuilder setKeyAlg(String value) {
        this._keyAlg = value;
        return this;
    }

    public TrustKeystoreBuilder setKeysize(Integer value) {
        this._keysize = value;
        return this;
    }

    public TrustKeystoreBuilder setKeystoreFile(byte[] value) {
        this._keystoreFile = value;
        return this;
    }

    public TrustKeystoreBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public TrustKeystoreBuilder setSignAlg(String value) {
        this._signAlg = value;
        return this;
    }

    public TrustKeystoreBuilder setStorePassword(String value) {
        this._storePassword = value;
        return this;
    }

    public TrustKeystoreBuilder setValidity(Integer value) {
        this._validity = value;
        return this;
    }

    public TrustKeystoreBuilder addAugmentation(Augmentation<TrustKeystore> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TrustKeystore>>, Augmentation<TrustKeystore>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public TrustKeystoreBuilder removeAugmentation(Class<? extends Augmentation<TrustKeystore>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull TrustKeystore build() {
        return new TrustKeystoreImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull TrustKeystore INSTANCE = new TrustKeystoreBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class TrustKeystoreImpl
    extends AbstractAugmentable<TrustKeystore>
    implements TrustKeystore {
        private final String _alias;
        private final String _dname;
        private final String _keyAlg;
        private final Integer _keysize;
        private final byte[] _keystoreFile;
        private final String _name;
        private final String _signAlg;
        private final String _storePassword;
        private final Integer _validity;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TrustKeystoreImpl(TrustKeystoreBuilder base) {
            super(base.augmentation);
            this._alias = base.getAlias();
            this._dname = base.getDname();
            this._keyAlg = base.getKeyAlg();
            this._keysize = base.getKeysize();
            this._keystoreFile = base.getKeystoreFile();
            this._name = base.getName();
            this._signAlg = base.getSignAlg();
            this._storePassword = base.getStorePassword();
            this._validity = base.getValidity();
        }

        @Override
        public String getAlias() {
            return this._alias;
        }

        @Override
        public String getDname() {
            return this._dname;
        }

        @Override
        public String getKeyAlg() {
            return this._keyAlg;
        }

        @Override
        public Integer getKeysize() {
            return this._keysize;
        }

        @Override
        public byte[] getKeystoreFile() {
            return this._keystoreFile == null ? null : (byte[])this._keystoreFile.clone();
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getSignAlg() {
            return this._signAlg;
        }

        @Override
        public String getStorePassword() {
            return this._storePassword;
        }

        @Override
        public Integer getValidity() {
            return this._validity;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = TrustKeystore.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return TrustKeystore.bindingEquals(this, obj);
        }

        public String toString() {
            return TrustKeystore.bindingToString(this);
        }
    }
}

