/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.AaaCertServiceConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.CtlKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.CtlKeystoreBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.TrustKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.TrustKeystoreBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class AaaCertServiceConfigBuilder {
    private String _bundleName;
    private CtlKeystore _ctlKeystore;
    private TrustKeystore _trustKeystore;
    private Boolean _useConfig;
    private Boolean _useMdsal;
    Map<Class<? extends Augmentation<AaaCertServiceConfig>>, Augmentation<AaaCertServiceConfig>> augmentation = Map.of();

    public AaaCertServiceConfigBuilder() {
    }

    public AaaCertServiceConfigBuilder(AaaCertServiceConfig base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AaaCertServiceConfig>>, Augmentation<AaaCertServiceConfig>>(aug);
        }
        this._bundleName = base.getBundleName();
        this._ctlKeystore = base.getCtlKeystore();
        this._trustKeystore = base.getTrustKeystore();
        this._useConfig = base.getUseConfig();
        this._useMdsal = base.getUseMdsal();
    }

    public static @NonNull AaaCertServiceConfig empty() {
        return LazyEmpty.INSTANCE;
    }

    public String getBundleName() {
        return this._bundleName;
    }

    public CtlKeystore getCtlKeystore() {
        return this._ctlKeystore;
    }

    public TrustKeystore getTrustKeystore() {
        return this._trustKeystore;
    }

    public Boolean getUseConfig() {
        return this._useConfig;
    }

    public Boolean getUseMdsal() {
        return this._useMdsal;
    }

    public <E$$ extends Augmentation<AaaCertServiceConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public AaaCertServiceConfigBuilder setBundleName(String value) {
        this._bundleName = value;
        return this;
    }

    public AaaCertServiceConfigBuilder setCtlKeystore(CtlKeystore value) {
        this._ctlKeystore = value;
        return this;
    }

    public AaaCertServiceConfigBuilder setTrustKeystore(TrustKeystore value) {
        this._trustKeystore = value;
        return this;
    }

    public AaaCertServiceConfigBuilder setUseConfig(Boolean value) {
        this._useConfig = value;
        return this;
    }

    public AaaCertServiceConfigBuilder setUseMdsal(Boolean value) {
        this._useMdsal = value;
        return this;
    }

    public AaaCertServiceConfigBuilder addAugmentation(Augmentation<AaaCertServiceConfig> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AaaCertServiceConfig>>, Augmentation<AaaCertServiceConfig>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public AaaCertServiceConfigBuilder removeAugmentation(Class<? extends Augmentation<AaaCertServiceConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull AaaCertServiceConfig build() {
        return new AaaCertServiceConfigImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull AaaCertServiceConfig INSTANCE = new AaaCertServiceConfigBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class AaaCertServiceConfigImpl
    extends AbstractAugmentable<AaaCertServiceConfig>
    implements AaaCertServiceConfig {
        private final String _bundleName;
        private final CtlKeystore _ctlKeystore;
        private final TrustKeystore _trustKeystore;
        private final Boolean _useConfig;
        private final Boolean _useMdsal;
        private int hash = 0;
        private volatile boolean hashValid = false;

        AaaCertServiceConfigImpl(AaaCertServiceConfigBuilder base) {
            super(base.augmentation);
            this._bundleName = base.getBundleName();
            this._ctlKeystore = base.getCtlKeystore();
            this._trustKeystore = base.getTrustKeystore();
            this._useConfig = base.getUseConfig();
            this._useMdsal = base.getUseMdsal();
        }

        @Override
        public String getBundleName() {
            return this._bundleName;
        }

        @Override
        public CtlKeystore getCtlKeystore() {
            return this._ctlKeystore;
        }

        @Override
        public TrustKeystore getTrustKeystore() {
            return this._trustKeystore;
        }

        @Override
        public Boolean getUseConfig() {
            return this._useConfig;
        }

        @Override
        public Boolean getUseMdsal() {
            return this._useMdsal;
        }

        @Override
        public CtlKeystore nonnullCtlKeystore() {
            return Objects.requireNonNullElse(this.getCtlKeystore(), CtlKeystoreBuilder.empty());
        }

        @Override
        public TrustKeystore nonnullTrustKeystore() {
            return Objects.requireNonNullElse(this.getTrustKeystore(), TrustKeystoreBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = AaaCertServiceConfig.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return AaaCertServiceConfig.bindingEquals(this, obj);
        }

        public String toString() {
            return AaaCertServiceConfig.bindingToString(this);
        }
    }
}

