/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.CtlKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.ctlkeystore.CipherSuites;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class CtlKeystoreBuilder {
    private String _alias;
    private List<CipherSuites> _cipherSuites;
    private String _dname;
    private String _keyAlg;
    private Integer _keysize;
    private String _name;
    private String _signAlg;
    private String _storePassword;
    private String _tlsProtocols;
    private Integer _validity;
    Map<Class<? extends Augmentation<CtlKeystore>>, Augmentation<CtlKeystore>> augmentation = Map.of();

    public CtlKeystoreBuilder() {
    }

    public CtlKeystoreBuilder(CtlKeystore base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CtlKeystore>>, Augmentation<CtlKeystore>>(aug);
        }
        this._alias = base.getAlias();
        this._cipherSuites = base.getCipherSuites();
        this._dname = base.getDname();
        this._keyAlg = base.getKeyAlg();
        this._keysize = base.getKeysize();
        this._name = base.getName();
        this._signAlg = base.getSignAlg();
        this._storePassword = base.getStorePassword();
        this._tlsProtocols = base.getTlsProtocols();
        this._validity = base.getValidity();
    }

    public static @NonNull CtlKeystore empty() {
        return LazyEmpty.INSTANCE;
    }

    public String getAlias() {
        return this._alias;
    }

    public List<CipherSuites> getCipherSuites() {
        return this._cipherSuites;
    }

    public String getDname() {
        return this._dname;
    }

    public String getKeyAlg() {
        return this._keyAlg;
    }

    public Integer getKeysize() {
        return this._keysize;
    }

    public String getName() {
        return this._name;
    }

    public String getSignAlg() {
        return this._signAlg;
    }

    public String getStorePassword() {
        return this._storePassword;
    }

    public String getTlsProtocols() {
        return this._tlsProtocols;
    }

    public Integer getValidity() {
        return this._validity;
    }

    public <E$$ extends Augmentation<CtlKeystore>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public CtlKeystoreBuilder setAlias(String value) {
        this._alias = value;
        return this;
    }

    public CtlKeystoreBuilder setCipherSuites(List<CipherSuites> values) {
        this._cipherSuites = values;
        return this;
    }

    public CtlKeystoreBuilder setDname(String value) {
        this._dname = value;
        return this;
    }

    public CtlKeystoreBuilder setKeyAlg(String value) {
        this._keyAlg = value;
        return this;
    }

    public CtlKeystoreBuilder setKeysize(Integer value) {
        this._keysize = value;
        return this;
    }

    public CtlKeystoreBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public CtlKeystoreBuilder setSignAlg(String value) {
        this._signAlg = value;
        return this;
    }

    public CtlKeystoreBuilder setStorePassword(String value) {
        this._storePassword = value;
        return this;
    }

    public CtlKeystoreBuilder setTlsProtocols(String value) {
        this._tlsProtocols = value;
        return this;
    }

    public CtlKeystoreBuilder setValidity(Integer value) {
        this._validity = value;
        return this;
    }

    public CtlKeystoreBuilder addAugmentation(Augmentation<CtlKeystore> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CtlKeystore>>, Augmentation<CtlKeystore>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public CtlKeystoreBuilder removeAugmentation(Class<? extends Augmentation<CtlKeystore>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull CtlKeystore build() {
        return new CtlKeystoreImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull CtlKeystore INSTANCE = new CtlKeystoreBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class CtlKeystoreImpl
    extends AbstractAugmentable<CtlKeystore>
    implements CtlKeystore {
        private final String _alias;
        private final List<CipherSuites> _cipherSuites;
        private final String _dname;
        private final String _keyAlg;
        private final Integer _keysize;
        private final String _name;
        private final String _signAlg;
        private final String _storePassword;
        private final String _tlsProtocols;
        private final Integer _validity;
        private int hash = 0;
        private volatile boolean hashValid = false;

        CtlKeystoreImpl(CtlKeystoreBuilder base) {
            super(base.augmentation);
            this._alias = base.getAlias();
            this._cipherSuites = CodeHelpers.emptyToNull(base.getCipherSuites());
            this._dname = base.getDname();
            this._keyAlg = base.getKeyAlg();
            this._keysize = base.getKeysize();
            this._name = base.getName();
            this._signAlg = base.getSignAlg();
            this._storePassword = base.getStorePassword();
            this._tlsProtocols = base.getTlsProtocols();
            this._validity = base.getValidity();
        }

        @Override
        public String getAlias() {
            return this._alias;
        }

        @Override
        public List<CipherSuites> getCipherSuites() {
            return this._cipherSuites;
        }

        @Override
        public String getDname() {
            return this._dname;
        }

        @Override
        public String getKeyAlg() {
            return this._keyAlg;
        }

        @Override
        public Integer getKeysize() {
            return this._keysize;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getSignAlg() {
            return this._signAlg;
        }

        @Override
        public String getStorePassword() {
            return this._storePassword;
        }

        @Override
        public String getTlsProtocols() {
            return this._tlsProtocols;
        }

        @Override
        public Integer getValidity() {
            return this._validity;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = CtlKeystore.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return CtlKeystore.bindingEquals(this, obj);
        }

        public String toString() {
            return CtlKeystore.bindingToString(this);
        }
    }
}

