package org.opendaylight.aaa.datastore.h2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Builds instances of type {@link IdmLightConfig IdmLightConfig}.
 * Initialize attributes and then invoke the {@link #build()} method to create an
 * immutable instance.
 * <p><em>{@code IdmLightConfigBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "IdmLightConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class IdmLightConfigBuilder {
  private static final long INIT_BIT_DB_USER = 0x1L;
  private static final long INIT_BIT_DB_PWD = 0x2L;
  private static final long OPT_BIT_DB_NAME = 0x1L;
  private static final long OPT_BIT_DB_DIRECTORY = 0x2L;
  private static final long OPT_BIT_DB_DRIVER = 0x4L;
  private static final long OPT_BIT_DB_VALID_TIME_OUT = 0x8L;
  private static final long OPT_BIT_DB_CONNECTION_STRING_PREFIX = 0x10L;
  private static final long OPT_BIT_DB_CONNECTION_STRING = 0x20L;
  private long initBits = 0x3L;
  private long optBits;

  private String dbName;
  private String dbDirectory;
  private String dbDriver;
  private String dbUser;
  private String dbPwd;
  private int dbValidTimeOut;
  private String dbConnectionStringPrefix;
  private String dbConnectionString;

  /**
   * Creates a builder for {@link IdmLightConfig IdmLightConfig} instances.
   * <pre>
   * new IdmLightConfigBuilder()
   *    .dbName(String) // optional {@link IdmLightConfig#getDbName() dbName}
   *    .dbDirectory(String) // optional {@link IdmLightConfig#getDbDirectory() dbDirectory}
   *    .dbDriver(String) // optional {@link IdmLightConfig#getDbDriver() dbDriver}
   *    .dbUser(String) // required {@link IdmLightConfig#getDbUser() dbUser}
   *    .dbPwd(String) // required {@link IdmLightConfig#getDbPwd() dbPwd}
   *    .dbValidTimeOut(int) // optional {@link IdmLightConfig#getDbValidTimeOut() dbValidTimeOut}
   *    .dbConnectionStringPrefix(String) // optional {@link IdmLightConfig#getDbConnectionStringPrefix() dbConnectionStringPrefix}
   *    .dbConnectionString(String) // optional {@link IdmLightConfig#getDbConnectionString() dbConnectionString}
   *    .build();
   * </pre>
   */
  public IdmLightConfigBuilder() {
  }

  /**
   * Initializes the value for the {@link IdmLightConfig#getDbName() dbName} attribute.
   * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IdmLightConfig#getDbName() dbName}.</em>
   * @param dbName The value for dbName 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final IdmLightConfigBuilder dbName(String dbName) {
    checkNotIsSet(dbNameIsSet(), "dbName");
    this.dbName = Objects.requireNonNull(dbName, "dbName");
    optBits |= OPT_BIT_DB_NAME;
    return this;
  }

  /**
   * Initializes the value for the {@link IdmLightConfig#getDbDirectory() dbDirectory} attribute.
   * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IdmLightConfig#getDbDirectory() dbDirectory}.</em>
   * @param dbDirectory The value for dbDirectory 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final IdmLightConfigBuilder dbDirectory(String dbDirectory) {
    checkNotIsSet(dbDirectoryIsSet(), "dbDirectory");
    this.dbDirectory = Objects.requireNonNull(dbDirectory, "dbDirectory");
    optBits |= OPT_BIT_DB_DIRECTORY;
    return this;
  }

  /**
   * Initializes the value for the {@link IdmLightConfig#getDbDriver() dbDriver} attribute.
   * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IdmLightConfig#getDbDriver() dbDriver}.</em>
   * @param dbDriver The value for dbDriver 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final IdmLightConfigBuilder dbDriver(String dbDriver) {
    checkNotIsSet(dbDriverIsSet(), "dbDriver");
    this.dbDriver = Objects.requireNonNull(dbDriver, "dbDriver");
    optBits |= OPT_BIT_DB_DRIVER;
    return this;
  }

  /**
   * Initializes the value for the {@link IdmLightConfig#getDbUser() dbUser} attribute.
   * @param dbUser The value for dbUser 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final IdmLightConfigBuilder dbUser(String dbUser) {
    checkNotIsSet(dbUserIsSet(), "dbUser");
    this.dbUser = Objects.requireNonNull(dbUser, "dbUser");
    initBits &= ~INIT_BIT_DB_USER;
    return this;
  }

  /**
   * Initializes the value for the {@link IdmLightConfig#getDbPwd() dbPwd} attribute.
   * @param dbPwd The value for dbPwd 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final IdmLightConfigBuilder dbPwd(String dbPwd) {
    checkNotIsSet(dbPwdIsSet(), "dbPwd");
    this.dbPwd = Objects.requireNonNull(dbPwd, "dbPwd");
    initBits &= ~INIT_BIT_DB_PWD;
    return this;
  }

  /**
   * Initializes the value for the {@link IdmLightConfig#getDbValidTimeOut() dbValidTimeOut} attribute.
   * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IdmLightConfig#getDbValidTimeOut() dbValidTimeOut}.</em>
   * @param dbValidTimeOut The value for dbValidTimeOut 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final IdmLightConfigBuilder dbValidTimeOut(int dbValidTimeOut) {
    checkNotIsSet(dbValidTimeOutIsSet(), "dbValidTimeOut");
    this.dbValidTimeOut = dbValidTimeOut;
    optBits |= OPT_BIT_DB_VALID_TIME_OUT;
    return this;
  }

  /**
   * Initializes the value for the {@link IdmLightConfig#getDbConnectionStringPrefix() dbConnectionStringPrefix} attribute.
   * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IdmLightConfig#getDbConnectionStringPrefix() dbConnectionStringPrefix}.</em>
   * @param dbConnectionStringPrefix The value for dbConnectionStringPrefix 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final IdmLightConfigBuilder dbConnectionStringPrefix(String dbConnectionStringPrefix) {
    checkNotIsSet(dbConnectionStringPrefixIsSet(), "dbConnectionStringPrefix");
    this.dbConnectionStringPrefix = Objects.requireNonNull(dbConnectionStringPrefix, "dbConnectionStringPrefix");
    optBits |= OPT_BIT_DB_CONNECTION_STRING_PREFIX;
    return this;
  }

  /**
   * Initializes the value for the {@link IdmLightConfig#getDbConnectionString() dbConnectionString} attribute.
   * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IdmLightConfig#getDbConnectionString() dbConnectionString}.</em>
   * @param dbConnectionString The value for dbConnectionString 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final IdmLightConfigBuilder dbConnectionString(String dbConnectionString) {
    checkNotIsSet(dbConnectionStringIsSet(), "dbConnectionString");
    this.dbConnectionString = Objects.requireNonNull(dbConnectionString, "dbConnectionString");
    optBits |= OPT_BIT_DB_CONNECTION_STRING;
    return this;
  }

  /**
   * Builds a new {@link IdmLightConfig IdmLightConfig}.
   * @return An immutable instance of IdmLightConfig
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public IdmLightConfig build() {
    checkRequiredAttributes();
    return new IdmLightConfigBuilder.IdmLightConfigImpl(this);
  }

  private boolean dbNameIsSet() {
    return (optBits & OPT_BIT_DB_NAME) != 0;
  }

  private boolean dbDirectoryIsSet() {
    return (optBits & OPT_BIT_DB_DIRECTORY) != 0;
  }

  private boolean dbDriverIsSet() {
    return (optBits & OPT_BIT_DB_DRIVER) != 0;
  }

  private boolean dbValidTimeOutIsSet() {
    return (optBits & OPT_BIT_DB_VALID_TIME_OUT) != 0;
  }

  private boolean dbConnectionStringPrefixIsSet() {
    return (optBits & OPT_BIT_DB_CONNECTION_STRING_PREFIX) != 0;
  }

  private boolean dbConnectionStringIsSet() {
    return (optBits & OPT_BIT_DB_CONNECTION_STRING) != 0;
  }

  private boolean dbUserIsSet() {
    return (initBits & INIT_BIT_DB_USER) == 0;
  }

  private boolean dbPwdIsSet() {
    return (initBits & INIT_BIT_DB_PWD) == 0;
  }

  private static void checkNotIsSet(boolean isSet, String name) {
    if (isSet) throw new IllegalStateException("Builder of IdmLightConfig is strict, attribute is already set: ".concat(name));
  }

  private void checkRequiredAttributes() {
    if (initBits != 0) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!dbUserIsSet()) attributes.add("dbUser");
    if (!dbPwdIsSet()) attributes.add("dbPwd");
    return "Cannot build IdmLightConfig, some of required attributes are not set " + attributes;
  }

  /**
   * Immutable implementation of {@link IdmLightConfig}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code new IdmLightConfigBuilder()}.
   */
  @Generated(from = "IdmLightConfig", generator = "Immutables")
  private static final class IdmLightConfigImpl extends IdmLightConfig {
    private final String dbName;
    private final String dbDirectory;
    private final String dbDriver;
    private final String dbUser;
    private final String dbPwd;
    private final int dbValidTimeOut;
    private final String dbConnectionStringPrefix;
    private final String dbConnectionString;

    private IdmLightConfigImpl(IdmLightConfigBuilder builder) {
      this.dbUser = builder.dbUser;
      this.dbPwd = builder.dbPwd;
      if (builder.dbNameIsSet()) {
        initShim.dbName(builder.dbName);
      }
      if (builder.dbDirectoryIsSet()) {
        initShim.dbDirectory(builder.dbDirectory);
      }
      if (builder.dbDriverIsSet()) {
        initShim.dbDriver(builder.dbDriver);
      }
      if (builder.dbValidTimeOutIsSet()) {
        initShim.dbValidTimeOut(builder.dbValidTimeOut);
      }
      if (builder.dbConnectionStringPrefixIsSet()) {
        initShim.dbConnectionStringPrefix(builder.dbConnectionStringPrefix);
      }
      if (builder.dbConnectionStringIsSet()) {
        initShim.dbConnectionString(builder.dbConnectionString);
      }
      this.dbName = initShim.getDbName();
      this.dbDirectory = initShim.getDbDirectory();
      this.dbDriver = initShim.getDbDriver();
      this.dbValidTimeOut = initShim.getDbValidTimeOut();
      this.dbConnectionStringPrefix = initShim.getDbConnectionStringPrefix();
      this.dbConnectionString = initShim.getDbConnectionString();
      this.initShim = null;
    }

    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    @SuppressWarnings("Immutable")
    private transient volatile InitShim initShim = new InitShim();

    @Generated(from = "IdmLightConfig", generator = "Immutables")
    private final class InitShim {
      private byte dbNameBuildStage = STAGE_UNINITIALIZED;
      private String dbName;

      String getDbName() {
        if (dbNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (dbNameBuildStage == STAGE_UNINITIALIZED) {
          dbNameBuildStage = STAGE_INITIALIZING;
          this.dbName = Objects.requireNonNull(IdmLightConfigImpl.super.getDbName(), "dbName");
          dbNameBuildStage = STAGE_INITIALIZED;
        }
        return this.dbName;
      }

      void dbName(String dbName) {
        this.dbName = dbName;
        dbNameBuildStage = STAGE_INITIALIZED;
      }

      private byte dbDirectoryBuildStage = STAGE_UNINITIALIZED;
      private String dbDirectory;

      String getDbDirectory() {
        if (dbDirectoryBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (dbDirectoryBuildStage == STAGE_UNINITIALIZED) {
          dbDirectoryBuildStage = STAGE_INITIALIZING;
          this.dbDirectory = Objects.requireNonNull(IdmLightConfigImpl.super.getDbDirectory(), "dbDirectory");
          dbDirectoryBuildStage = STAGE_INITIALIZED;
        }
        return this.dbDirectory;
      }

      void dbDirectory(String dbDirectory) {
        this.dbDirectory = dbDirectory;
        dbDirectoryBuildStage = STAGE_INITIALIZED;
      }

      private byte dbDriverBuildStage = STAGE_UNINITIALIZED;
      private String dbDriver;

      String getDbDriver() {
        if (dbDriverBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (dbDriverBuildStage == STAGE_UNINITIALIZED) {
          dbDriverBuildStage = STAGE_INITIALIZING;
          this.dbDriver = Objects.requireNonNull(IdmLightConfigImpl.super.getDbDriver(), "dbDriver");
          dbDriverBuildStage = STAGE_INITIALIZED;
        }
        return this.dbDriver;
      }

      void dbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
        dbDriverBuildStage = STAGE_INITIALIZED;
      }

      private byte dbValidTimeOutBuildStage = STAGE_UNINITIALIZED;
      private int dbValidTimeOut;

      int getDbValidTimeOut() {
        if (dbValidTimeOutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (dbValidTimeOutBuildStage == STAGE_UNINITIALIZED) {
          dbValidTimeOutBuildStage = STAGE_INITIALIZING;
          this.dbValidTimeOut = IdmLightConfigImpl.super.getDbValidTimeOut();
          dbValidTimeOutBuildStage = STAGE_INITIALIZED;
        }
        return this.dbValidTimeOut;
      }

      void dbValidTimeOut(int dbValidTimeOut) {
        this.dbValidTimeOut = dbValidTimeOut;
        dbValidTimeOutBuildStage = STAGE_INITIALIZED;
      }

      private byte dbConnectionStringPrefixBuildStage = STAGE_UNINITIALIZED;
      private String dbConnectionStringPrefix;

      String getDbConnectionStringPrefix() {
        if (dbConnectionStringPrefixBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (dbConnectionStringPrefixBuildStage == STAGE_UNINITIALIZED) {
          dbConnectionStringPrefixBuildStage = STAGE_INITIALIZING;
          this.dbConnectionStringPrefix = Objects.requireNonNull(IdmLightConfigImpl.super.getDbConnectionStringPrefix(), "dbConnectionStringPrefix");
          dbConnectionStringPrefixBuildStage = STAGE_INITIALIZED;
        }
        return this.dbConnectionStringPrefix;
      }

      void dbConnectionStringPrefix(String dbConnectionStringPrefix) {
        this.dbConnectionStringPrefix = dbConnectionStringPrefix;
        dbConnectionStringPrefixBuildStage = STAGE_INITIALIZED;
      }

      private byte dbConnectionStringBuildStage = STAGE_UNINITIALIZED;
      private String dbConnectionString;

      String getDbConnectionString() {
        if (dbConnectionStringBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (dbConnectionStringBuildStage == STAGE_UNINITIALIZED) {
          dbConnectionStringBuildStage = STAGE_INITIALIZING;
          this.dbConnectionString = Objects.requireNonNull(IdmLightConfigImpl.super.getDbConnectionString(), "dbConnectionString");
          dbConnectionStringBuildStage = STAGE_INITIALIZED;
        }
        return this.dbConnectionString;
      }

      void dbConnectionString(String dbConnectionString) {
        this.dbConnectionString = dbConnectionString;
        dbConnectionStringBuildStage = STAGE_INITIALIZED;
      }

      private String formatInitCycleMessage() {
        List<String> attributes = new ArrayList<>();
        if (dbNameBuildStage == STAGE_INITIALIZING) attributes.add("dbName");
        if (dbDirectoryBuildStage == STAGE_INITIALIZING) attributes.add("dbDirectory");
        if (dbDriverBuildStage == STAGE_INITIALIZING) attributes.add("dbDriver");
        if (dbValidTimeOutBuildStage == STAGE_INITIALIZING) attributes.add("dbValidTimeOut");
        if (dbConnectionStringPrefixBuildStage == STAGE_INITIALIZING) attributes.add("dbConnectionStringPrefix");
        if (dbConnectionStringBuildStage == STAGE_INITIALIZING) attributes.add("dbConnectionString");
        return "Cannot build IdmLightConfig, attribute initializers form cycle " + attributes;
      }
    }

    /**
     * @return The value of the {@code dbName} attribute
     */
    @Override
    public String getDbName() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.getDbName()
          : this.dbName;
    }

    /**
     * @return The value of the {@code dbDirectory} attribute
     */
    @Override
    public String getDbDirectory() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.getDbDirectory()
          : this.dbDirectory;
    }

    /**
     * @return The value of the {@code dbDriver} attribute
     */
    @Override
    public String getDbDriver() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.getDbDriver()
          : this.dbDriver;
    }

    /**
     * @return The value of the {@code dbUser} attribute
     */
    @Override
    public String getDbUser() {
      return dbUser;
    }

    /**
     * @return The value of the {@code dbPwd} attribute
     */
    @Override
    public String getDbPwd() {
      return dbPwd;
    }

    /**
     * @return The value of the {@code dbValidTimeOut} attribute
     */
    @Override
    public int getDbValidTimeOut() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.getDbValidTimeOut()
          : this.dbValidTimeOut;
    }

    /**
     * @return The value of the {@code dbConnectionStringPrefix} attribute
     */
    @Override
    public String getDbConnectionStringPrefix() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.getDbConnectionStringPrefix()
          : this.dbConnectionStringPrefix;
    }

    /**
     * @return The value of the {@code dbConnectionString} attribute
     */
    @Override
    public String getDbConnectionString() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.getDbConnectionString()
          : this.dbConnectionString;
    }

    /**
     * This instance is equal to all instances of {@code IdmLightConfigImpl} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(Object another) {
      if (this == another) return true;
      return another instanceof IdmLightConfigBuilder.IdmLightConfigImpl
          && equalTo(0, (IdmLightConfigBuilder.IdmLightConfigImpl) another);
    }

    private boolean equalTo(int synthetic, IdmLightConfigBuilder.IdmLightConfigImpl another) {
      return dbName.equals(another.dbName)
          && dbDirectory.equals(another.dbDirectory)
          && dbDriver.equals(another.dbDriver)
          && dbUser.equals(another.dbUser)
          && dbPwd.equals(another.dbPwd)
          && dbValidTimeOut == another.dbValidTimeOut
          && dbConnectionStringPrefix.equals(another.dbConnectionStringPrefix)
          && dbConnectionString.equals(another.dbConnectionString);
    }

    /**
     * Computes a hash code from attributes: {@code dbName}, {@code dbDirectory}, {@code dbDriver}, {@code dbUser}, {@code dbPwd}, {@code dbValidTimeOut}, {@code dbConnectionStringPrefix}, {@code dbConnectionString}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + dbName.hashCode();
      h += (h << 5) + dbDirectory.hashCode();
      h += (h << 5) + dbDriver.hashCode();
      h += (h << 5) + dbUser.hashCode();
      h += (h << 5) + dbPwd.hashCode();
      h += (h << 5) + dbValidTimeOut;
      h += (h << 5) + dbConnectionStringPrefix.hashCode();
      h += (h << 5) + dbConnectionString.hashCode();
      return h;
    }
  }
}
