/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.impl.password.service;

import org.apache.shiro.codec.Base64;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.crypto.hash.SimpleHashRequest;
import org.apache.shiro.util.ByteSource;
import org.opendaylight.aaa.api.password.service.PasswordHash;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.opendaylight.aaa.impl.password.service.PasswordHashImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.password.service.config.rev170619.PasswordServiceConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.password.service.config.rev170619.PasswordServiceConfigBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPasswordHashService
implements PasswordHashService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPasswordHashService.class);
    public static final String DEFAULT_HASH_ALGORITHM = "SHA-512";
    public static final int DEFAULT_NUM_ITERATIONS = 20000;
    private final DefaultHashService hashService;

    public DefaultPasswordHashService() {
        this(new PasswordServiceConfigBuilder().build());
    }

    public DefaultPasswordHashService(PasswordServiceConfig passwordServiceConfig) {
        this.hashService = DefaultPasswordHashService.createHashService(passwordServiceConfig.getIterations(), passwordServiceConfig.getAlgorithm(), passwordServiceConfig.getPrivateSalt());
    }

    public PasswordHash getPasswordHash(String password) {
        Hash hash = this.hashService.computeHash(new HashRequest.Builder().setAlgorithmName(this.hashService.getHashAlgorithmName()).setIterations(this.hashService.getHashIterations()).setSource(ByteSource.Util.bytes((String)password)).build());
        return PasswordHashImpl.create(hash.getAlgorithmName(), hash.getSalt().toBase64(), hash.getIterations(), hash.toBase64());
    }

    public PasswordHash getPasswordHash(String password, String salt) {
        Hash hash = this.hashService.computeHash((HashRequest)new SimpleHashRequest(this.hashService.getHashAlgorithmName(), ByteSource.Util.bytes((String)password), ByteSource.Util.bytes((byte[])Base64.decode((String)salt)), this.hashService.getHashIterations()));
        return PasswordHashImpl.create(hash.getAlgorithmName(), hash.getSalt().toBase64(), hash.getIterations(), hash.toBase64());
    }

    public boolean passwordsMatch(String plaintext, String stored, String salt) {
        return this.getPasswordHash(plaintext, salt).getHashedPassword().equals(stored);
    }

    private static DefaultHashService createHashService(Integer numIterations, String hashAlgorithm, String privateSalt) {
        DefaultHashService hashService = new DefaultHashService();
        if (numIterations != null) {
            hashService.setHashIterations(numIterations.intValue());
            LOG.info("DefaultPasswordHashService will utilize configured iteration count={}", (Object)numIterations);
        } else {
            hashService.setHashIterations(20000);
            LOG.info("DefaultPasswordHashService will utilize default iteration count={}", (Object)20000);
        }
        if (hashAlgorithm != null) {
            hashService.setHashAlgorithmName(hashAlgorithm);
            LOG.info("DefaultPasswordHashService will utilize configured algorithm={}", (Object)hashAlgorithm);
        } else {
            hashService.setHashAlgorithmName(DEFAULT_HASH_ALGORITHM);
            LOG.info("DefaultPasswordHashService will utilize default algorithm={}", (Object)DEFAULT_HASH_ALGORITHM);
        }
        if (privateSalt != null) {
            hashService.setPrivateSalt(ByteSource.Util.bytes((String)privateSalt));
            LOG.info("DefaultPasswordHashService will utilize a configured private salt");
        } else {
            hashService.setGeneratePublicSalt(true);
            LOG.info("DefaultPasswordHashService will not utilize a private salt, since none was configured");
        }
        return hashService;
    }
}

