/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.impl.password.service;

import org.opendaylight.aaa.api.password.service.PasswordHash;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.opendaylight.aaa.impl.password.service.DefaultPasswordHashService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.password.service.config.rev170619.PasswordServiceConfig;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, property={"type=default"})
public final class OSGiPasswordHashService
implements PasswordHashService {
    private volatile DefaultPasswordHashService delegate = null;

    public PasswordHash getPasswordHash(String password) {
        return this.delegate.getPasswordHash(password);
    }

    public PasswordHash getPasswordHash(String password, String salt) {
        return this.delegate.getPasswordHash(password, salt);
    }

    public boolean passwordsMatch(String plaintext, String stored, String salt) {
        return this.delegate.passwordsMatch(plaintext, stored, salt);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MANDATORY)
    void bindConfig(PasswordServiceConfig config) {
        this.updatedConfig(config);
    }

    void unbindConfig(PasswordServiceConfig config) {
        this.delegate = null;
    }

    void updatedConfig(PasswordServiceConfig config) {
        this.delegate = new DefaultPasswordHashService(config);
    }
}

