/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.impl.password.service;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.opendaylight.aaa.impl.password.service.OSGiPasswordServiceConfig;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.password.service.config.rev170619.PasswordServiceConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.password.service.config.rev170619.PasswordServiceConfigBuilder;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(service={})
public final class OSGiPasswordServiceConfigBootstrap
implements DataListener<PasswordServiceConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiPasswordServiceConfigBootstrap.class);
    private final ComponentFactory<OSGiPasswordServiceConfig> configFactory;
    private Registration registration;
    private ComponentInstance<?> instance;

    @Activate
    public OSGiPasswordServiceConfigBootstrap(@Reference DataBroker dataBroker, @Reference(target="(component.factory=org.opendaylight.aaa.impl.password.service.OSGiPasswordServiceConfig)") ComponentFactory<OSGiPasswordServiceConfig> configFactory) {
        this.configFactory = Objects.requireNonNull(configFactory);
        this.registration = dataBroker.registerDataListener(DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)InstanceIdentifier.create(PasswordServiceConfig.class)), (DataListener)this);
        LOG.info("Listening for password service configuration");
    }

    @Deactivate
    synchronized void deactivate() {
        this.registration.close();
        this.registration = null;
        if (this.instance != null) {
            this.instance.dispose();
            this.instance = null;
        }
        LOG.info("No longer listening for password service configuration");
    }

    public synchronized void dataChangedTo(PasswordServiceConfig data) {
        if (this.registration != null) {
            ComponentInstance newInstance = this.configFactory.newInstance(OSGiPasswordServiceConfig.props(data != null ? data : new PasswordServiceConfigBuilder().build()));
            if (this.instance != null) {
                this.instance.dispose();
            }
            this.instance = newInstance;
        }
    }
}

