package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa</b>
 * <pre>
 * grouping domain {
 *   leaf domainid {
 *     type string;
 *   }
 *   leaf name {
 *     type string;
 *   }
 *   leaf description {
 *     type string;
 *     default "";
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface Domain
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("domain");

    @Override
    Class<? extends Domain> implementedInterface();
    
    /**
     * Return domainid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         An internal wiring detail in the form 'name'.
     *     </code>
     * </pre>
     *
     * @return {@code String} domainid, or {@code null} if it is not present.
     *
     */
    String getDomainid();
    
    /**
     * Return domainid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         An internal wiring detail in the form 'name'.
     *     </code>
     * </pre>
     *
     * @return {@code String} domainid, guaranteed to be non-null.
     * @throws NoSuchElementException if domainid is not present
     *
     */
    default @NonNull String requireDomainid() {
        return CodeHelpers.require(getDomainid(), "domainid");
    }
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The name of the domain.
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The name of the domain.
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return description, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A description for the domain; defaults to the empty string.
     *     </code>
     * </pre>
     *
     * @return {@code String} description, or {@code null} if it is not present.
     *
     */
    String getDescription();
    
    /**
     * Return description, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         A description for the domain; defaults to the empty string.
     *     </code>
     * </pre>
     *
     * @return {@code String} description, guaranteed to be non-null.
     * @throws NoSuchElementException if description is not present
     *
     */
    default @NonNull String requireDescription() {
        return CodeHelpers.require(getDescription(), "description");
    }

}

