package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.permission.Permissions;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa</b>
 * <pre>
 * grouping http-permission {
 *   leaf resource {
 *     type string;
 *     default *;
 *   }
 *   leaf index {
 *     type uint32;
 *   }
 *   list permissions {
 *     leaf-list actions {
 *       type enumeration {
 *         enum get;
 *         enum put;
 *         enum post;
 *         enum patch;
 *         enum delete;
 *       }
 *     }
 *     leaf role {
 *       type string;
 *     }
 *   }
 *   leaf description {
 *     type string;
 *     default "";
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface HttpPermission
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("http-permission");

    @Override
    Class<? extends HttpPermission> implementedInterface();
    
    /**
     * Return resource, or {@code null} if it is not present.
     *
     * @return {@code String} resource, or {@code null} if it is not present.
     *
     */
    String getResource();
    
    /**
     * Return resource, guaranteed to be non-null.
     *
     * @return {@code String} resource, guaranteed to be non-null.
     * @throws NoSuchElementException if resource is not present
     *
     */
    default @NonNull String requireResource() {
        return CodeHelpers.require(getResource(), "resource");
    }
    
    /**
     * Return index, or {@code null} if it is not present.
     *
     * @return {@code Uint32} index, or {@code null} if it is not present.
     *
     */
    Uint32 getIndex();
    
    /**
     * Return index, guaranteed to be non-null.
     *
     * @return {@code Uint32} index, guaranteed to be non-null.
     * @throws NoSuchElementException if index is not present
     *
     */
    default @NonNull Uint32 requireIndex() {
        return CodeHelpers.require(getIndex(), "index");
    }
    
    /**
     * Return permissions, or {@code null} if it is not present.
     *
     * @return {@code List<Permissions>} permissions, or {@code null} if it is not present.
     *
     */
    @Nullable List<Permissions> getPermissions();
    
    /**
     * Return permissions, or an empty list if it is not present.
     *
     * @return {@code List<Permissions>} permissions, or an empty list if it is not present.
     *
     */
    default @NonNull List<Permissions> nonnullPermissions() {
        return CodeHelpers.nonnull(getPermissions());
    }
    
    /**
     * Return description, or {@code null} if it is not present.
     *
     * @return {@code String} description, or {@code null} if it is not present.
     *
     */
    String getDescription();
    
    /**
     * Return description, guaranteed to be non-null.
     *
     * @return {@code String} description, guaranteed to be non-null.
     * @throws NoSuchElementException if description is not present
     *
     */
    default @NonNull String requireDescription() {
        return CodeHelpers.require(getDescription(), "description");
    }

}

