package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa</b>
 * <pre>
 * grouping role {
 *   leaf roleid {
 *     type string;
 *   }
 *   leaf name {
 *     type string;
 *   }
 *   leaf description {
 *     type string;
 *     default "";
 *   }
 *   leaf domainid {
 *     type string;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface Role
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("role");

    @Override
    Class<? extends Role> implementedInterface();
    
    /**
     * Return roleid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         An internal wiring detail in the form 'name'.
     *     </code>
     * </pre>
     *
     * @return {@code String} roleid, or {@code null} if it is not present.
     *
     */
    String getRoleid();
    
    /**
     * Return roleid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         An internal wiring detail in the form 'name'.
     *     </code>
     * </pre>
     *
     * @return {@code String} roleid, guaranteed to be non-null.
     * @throws NoSuchElementException if roleid is not present
     *
     */
    default @NonNull String requireRoleid() {
        return CodeHelpers.require(getRoleid(), "roleid");
    }
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The name for the role.
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The name for the role.
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return description, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A description of the role; defaults to the empty string.
     *     </code>
     * </pre>
     *
     * @return {@code String} description, or {@code null} if it is not present.
     *
     */
    String getDescription();
    
    /**
     * Return description, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         A description of the role; defaults to the empty string.
     *     </code>
     * </pre>
     *
     * @return {@code String} description, guaranteed to be non-null.
     * @throws NoSuchElementException if description is not present
     *
     */
    default @NonNull String requireDescription() {
        return CodeHelpers.require(getDescription(), "description");
    }
    
    /**
     * Return domainid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The domain associated with the role.
     *     </code>
     * </pre>
     *
     * @return {@code String} domainid, or {@code null} if it is not present.
     *
     */
    String getDomainid();
    
    /**
     * Return domainid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The domain associated with the role.
     *     </code>
     * </pre>
     *
     * @return {@code String} domainid, guaranteed to be non-null.
     * @throws NoSuchElementException if domainid is not present
     *
     */
    default @NonNull String requireDomainid() {
        return CodeHelpers.require(getDomainid(), "domainid");
    }

}

