package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.domains;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;

/**
 * This class represents the key of {@link Domains} class.
 *
 * @see Domains
 *
 */
@Generated("mdsal-binding-generator")
public class DomainsKey
 implements Key<Domains> {
    @java.io.Serial
    private static final long serialVersionUID = -6253175116860739361L;
    private final String _domainid;


    /**
     * Constructs an instance.
     *
     * @param _domainid the entity domainid
     * @throws NullPointerException if any of the arguments are null
     */
    public DomainsKey(@NonNull String _domainid) {
        this._domainid = CodeHelpers.requireKeyProp(_domainid, "domainid");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public DomainsKey(DomainsKey source) {
        this._domainid = source._domainid;
    }


    /**
     * Return domainid, guaranteed to be non-null.
     *
     * @return {@code String} domainid, guaranteed to be non-null.
     */
    public @NonNull String getDomainid() {
        return _domainid;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_domainid);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof DomainsKey other
            && Objects.equals(_domainid, other._domainid);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(DomainsKey.class);
        CodeHelpers.appendValue(helper, "domainid", _domainid);
        return helper.toString();
    }
}

