package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.roles;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;

/**
 * This class represents the key of {@link Roles} class.
 *
 * @see Roles
 *
 */
@Generated("mdsal-binding-generator")
public class RolesKey
 implements Key<Roles> {
    @java.io.Serial
    private static final long serialVersionUID = 8314035760084485024L;
    private final String _roleid;


    /**
     * Constructs an instance.
     *
     * @param _roleid the entity roleid
     * @throws NullPointerException if any of the arguments are null
     */
    public RolesKey(@NonNull String _roleid) {
        this._roleid = CodeHelpers.requireKeyProp(_roleid, "roleid");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public RolesKey(RolesKey source) {
        this._roleid = source._roleid;
    }


    /**
     * Return roleid, guaranteed to be non-null.
     *
     * @return {@code String} roleid, guaranteed to be non-null.
     */
    public @NonNull String getRoleid() {
        return _roleid;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_roleid);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof RolesKey other
            && Objects.equals(_roleid, other._roleid);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(RolesKey.class);
        CodeHelpers.appendValue(helper, "roleid", _roleid);
        return helper.toString();
    }
}

