package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.users;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.User;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Users} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Users createUsers(int fooXyzzy, int barBaz) {
 *         return new UsersBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Users, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Users
 *
 */
@Generated("mdsal-binding-generator")
public class UsersBuilder {

    private String _description;
    private String _domainid;
    private String _email;
    private Boolean _enabled;
    private String _name;
    private String _password;
    private String _salt;
    private String _userid;
    private UsersKey key;


    Map<Class<? extends Augmentation<Users>>, Augmentation<Users>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public UsersBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link User}.
     *
     * @param arg User from which the builder should be initialized
     */
    public UsersBuilder(User arg) {
        this._userid = arg.getUserid();
        this._name = arg.getName();
        this._description = arg.getDescription();
        this._enabled = arg.getEnabled();
        this._email = arg.getEmail();
        this._password = arg.getPassword();
        this._salt = arg.getSalt();
        this._domainid = arg.getDomainid();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link Users}.
     *
     * @param base Users from which the builder should be initialized
     */
    public UsersBuilder(Users base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._userid = base.getUserid();
        this._description = base.getDescription();
        this._domainid = base.getDomainid();
        this._email = base.getEmail();
        this._enabled = base.getEnabled();
        this._name = base.getName();
        this._password = base.getPassword();
        this._salt = base.getSalt();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link User}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof User castArg) {
            this._userid = castArg.getUserid();
            this._name = castArg.getName();
            this._description = castArg.getDescription();
            this._enabled = castArg.getEnabled();
            this._email = castArg.getEmail();
            this._password = castArg.getPassword();
            this._salt = castArg.getSalt();
            this._domainid = castArg.getDomainid();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[User]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Users#key()}.
     *
     * @return current value
     */
    public UsersKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Users#getDescription()}.
     *
     * @return current value
     */
    public String getDescription() {
        return _description;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Users#getDomainid()}.
     *
     * @return current value
     */
    public String getDomainid() {
        return _domainid;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Users#getEmail()}.
     *
     * @return current value
     */
    public String getEmail() {
        return _email;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Users#getEnabled()}.
     *
     * @return current value
     */
    public Boolean getEnabled() {
        return _enabled;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Users#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Users#getPassword()}.
     *
     * @return current value
     */
    public String getPassword() {
        return _password;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Users#getSalt()}.
     *
     * @return current value
     */
    public String getSalt() {
        return _salt;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Users#getUserid()}.
     *
     * @return current value
     */
    public String getUserid() {
        return _userid;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Users>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link Users#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public UsersBuilder withKey(final UsersKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Users#getDescription()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UsersBuilder setDescription(final String value) {
        this._description = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Users#getDomainid()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UsersBuilder setDomainid(final String value) {
        this._domainid = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Users#getEmail()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UsersBuilder setEmail(final String value) {
        this._email = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Users#getEnabled()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UsersBuilder setEnabled(final Boolean value) {
        this._enabled = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Users#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UsersBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Users#getPassword()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UsersBuilder setPassword(final String value) {
        this._password = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Users#getSalt()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UsersBuilder setSalt(final String value) {
        this._salt = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Users#getUserid()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public UsersBuilder setUserid(final String value) {
        this._userid = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public UsersBuilder addAugmentation(Augmentation<Users> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public UsersBuilder removeAugmentation(Class<? extends Augmentation<Users>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Users} instance.
     *
     * @return A new {@link Users} instance.
     */
    public @NonNull Users build() {
        return new UsersImpl(this);
    }

    private static final class UsersImpl
        extends AbstractAugmentable<Users>
        implements Users {
    
        private final String _description;
        private final String _domainid;
        private final String _email;
        private final Boolean _enabled;
        private final String _name;
        private final String _password;
        private final String _salt;
        private final String _userid;
        private final UsersKey key;
    
        UsersImpl(UsersBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new UsersKey(base.getUserid());
            }
            this._userid = key.getUserid();
            this._description = base.getDescription();
            this._domainid = base.getDomainid();
            this._email = base.getEmail();
            this._enabled = base.getEnabled();
            this._name = base.getName();
            this._password = base.getPassword();
            this._salt = base.getSalt();
        }
    
        @Override
        public UsersKey key() {
            return key;
        }
        
        @Override
        public String getDescription() {
            return _description;
        }
        
        @Override
        public String getDomainid() {
            return _domainid;
        }
        
        @Override
        public String getEmail() {
            return _email;
        }
        
        @Override
        public Boolean getEnabled() {
            return _enabled;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public String getPassword() {
            return _password;
        }
        
        @Override
        public String getSalt() {
            return _salt;
        }
        
        @Override
        public String getUserid() {
            return _userid;
        }
    
        
        
        
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Users.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Users.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Users.bindingToString(this);
        }
    }
}
