package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.users;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;

/**
 * This class represents the key of {@link Users} class.
 *
 * @see Users
 *
 */
@Generated("mdsal-binding-generator")
public class UsersKey
 implements Key<Users> {
    @java.io.Serial
    private static final long serialVersionUID = 2800200720557438341L;
    private final String _userid;


    /**
     * Constructs an instance.
     *
     * @param _userid the entity userid
     * @throws NullPointerException if any of the arguments are null
     */
    public UsersKey(@NonNull String _userid) {
        this._userid = CodeHelpers.requireKeyProp(_userid, "userid");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public UsersKey(UsersKey source) {
        this._userid = source._userid;
    }


    /**
     * Return userid, guaranteed to be non-null.
     *
     * @return {@code String} userid, guaranteed to be non-null.
     */
    public @NonNull String getUserid() {
        return _userid;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_userid);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof UsersKey other
            && Objects.equals(_userid, other._userid);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(UsersKey.class);
        CodeHelpers.appendValue(helper, "userid", _userid);
        return helper.toString();
    }
}

