/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.authorization.policies;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.HttpPermission;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.authorization.policies.Policies;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.authorization.policies.PoliciesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.permission.Permissions;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class PoliciesBuilder {
    private String _description;
    private Uint32 _index;
    private List<Permissions> _permissions;
    private String _resource;
    private PoliciesKey key;
    Map<Class<? extends Augmentation<Policies>>, Augmentation<Policies>> augmentation = Map.of();

    public PoliciesBuilder() {
    }

    public PoliciesBuilder(HttpPermission arg) {
        this._resource = arg.getResource();
        this._index = arg.getIndex();
        this._permissions = arg.getPermissions();
        this._description = arg.getDescription();
    }

    public PoliciesBuilder(Policies base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Policies>>, Augmentation<Policies>>(aug);
        }
        this.key = base.key();
        this._resource = base.getResource();
        this._description = base.getDescription();
        this._index = base.getIndex();
        this._permissions = base.getPermissions();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof HttpPermission) {
            HttpPermission castArg = (HttpPermission)arg;
            this._resource = castArg.getResource();
            this._index = castArg.getIndex();
            this._permissions = castArg.getPermissions();
            this._description = castArg.getDescription();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[HttpPermission]");
    }

    public PoliciesKey key() {
        return this.key;
    }

    public String getDescription() {
        return this._description;
    }

    public Uint32 getIndex() {
        return this._index;
    }

    public List<Permissions> getPermissions() {
        return this._permissions;
    }

    public String getResource() {
        return this._resource;
    }

    public <E$$ extends Augmentation<Policies>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public PoliciesBuilder withKey(PoliciesKey key) {
        this.key = key;
        return this;
    }

    public PoliciesBuilder setDescription(String value) {
        this._description = value;
        return this;
    }

    public PoliciesBuilder setIndex(Uint32 value) {
        this._index = value;
        return this;
    }

    public PoliciesBuilder setPermissions(List<Permissions> values) {
        this._permissions = values;
        return this;
    }

    public PoliciesBuilder setResource(String value) {
        this._resource = value;
        return this;
    }

    public PoliciesBuilder addAugmentation(Augmentation<Policies> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Policies>>, Augmentation<Policies>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public PoliciesBuilder removeAugmentation(Class<? extends Augmentation<Policies>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Policies build() {
        return new PoliciesImpl(this);
    }

    private static final class PoliciesImpl
    extends AbstractAugmentable<Policies>
    implements Policies {
        private final String _description;
        private final Uint32 _index;
        private final List<Permissions> _permissions;
        private final String _resource;
        private final PoliciesKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PoliciesImpl(PoliciesBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new PoliciesKey(base.getResource());
            this._resource = this.key.getResource();
            this._description = base.getDescription();
            this._index = base.getIndex();
            this._permissions = CodeHelpers.emptyToNull(base.getPermissions());
        }

        @Override
        public PoliciesKey key() {
            return this.key;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public Uint32 getIndex() {
            return this._index;
        }

        @Override
        public List<Permissions> getPermissions() {
            return this._permissions;
        }

        @Override
        public String getResource() {
            return this._resource;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Policies.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Policies.bindingEquals(this, obj);
        }

        public String toString() {
            return Policies.bindingToString(this);
        }
    }
}

