/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.web;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

public interface ResourceDetails {
    public @NonNull String name();

    public @NonNull String alias();

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String alias;

        private Builder() {
        }

        public @NonNull Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public @NonNull Builder alias(String alias) {
            this.alias = Objects.requireNonNull(alias);
            return this;
        }

        public @NonNull ResourceDetails build() {
            if (this.name == null) {
                throw new IllegalStateException("name not specified");
            }
            return new ImmutableResourceDetails(this.name, this.alias == null ? this.name : this.alias);
        }

        private record ImmutableResourceDetails(String name, String alias) implements ResourceDetails
        {
        }
    }
}

