/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.web;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.Servlet;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.aaa.web.ServletSpec;

public interface ServletDetails {
    public @NonNull Servlet servlet();

    public @NonNull String name();

    public @NonNull List<String> urlPatterns();

    public @NonNull Map<String, String> initParams();

    public boolean asyncSupported();

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final ImmutableMap.Builder<String, String> initParams = ImmutableMap.builder();
        private final ImmutableList.Builder<String> urlPatterns = ImmutableList.builder();
        private Servlet servlet;
        private String name;
        private boolean asyncSupported;

        private Builder() {
        }

        public @NonNull Builder servlet(Servlet servlet) {
            this.servlet = Objects.requireNonNull(servlet);
            return this;
        }

        public @NonNull Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public @NonNull Builder addUrlPattern(String urlPattern) {
            this.urlPatterns.add((Object)ServletSpec.requireMappingSpec(urlPattern));
            return this;
        }

        public @NonNull Builder putInitParam(String key, String value) {
            this.initParams.put((Object)key, (Object)value);
            return this;
        }

        public @NonNull Builder asyncSupported(boolean asyncSupported) {
            this.asyncSupported = asyncSupported;
            return this;
        }

        public @NonNull ServletDetails build() {
            if (this.servlet == null) {
                throw new IllegalStateException("No servlet specified");
            }
            return new ImmutableServletDetails(this.servlet, this.name != null ? this.name : this.servlet.getClass().getName(), (ImmutableList<String>)this.urlPatterns.build(), (ImmutableMap<String, String>)this.initParams.build(), this.asyncSupported);
        }

        private static final class ImmutableServletDetails
        extends Record
        implements ServletDetails {
            private final Servlet servlet;
            private final String name;
            private final ImmutableList<String> urlPatterns;
            private final ImmutableMap<String, String> initParams;
            private final boolean asyncSupported;

            ImmutableServletDetails(Servlet servlet, String name, ImmutableList<String> urlPatterns, ImmutableMap<String, String> initParams, boolean asyncSupported) {
                if (urlPatterns.isEmpty()) {
                    throw new IllegalStateException("No urlPattern specified");
                }
                this.servlet = servlet;
                this.name = name;
                this.urlPatterns = urlPatterns;
                this.initParams = initParams;
                this.asyncSupported = asyncSupported;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{ImmutableServletDetails.class, "servlet;name;urlPatterns;initParams;asyncSupported", "servlet", "name", "urlPatterns", "initParams", "asyncSupported"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ImmutableServletDetails.class, "servlet;name;urlPatterns;initParams;asyncSupported", "servlet", "name", "urlPatterns", "initParams", "asyncSupported"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ImmutableServletDetails.class, "servlet;name;urlPatterns;initParams;asyncSupported", "servlet", "name", "urlPatterns", "initParams", "asyncSupported"}, this, o);
            }

            @Override
            public Servlet servlet() {
                return this.servlet;
            }

            @Override
            public String name() {
                return this.name;
            }

            public ImmutableList<String> urlPatterns() {
                return this.urlPatterns;
            }

            public ImmutableMap<String, String> initParams() {
                return this.initParams;
            }

            @Override
            public boolean asyncSupported() {
                return this.asyncSupported;
            }
        }
    }
}

