/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.web;

import com.google.common.base.Preconditions;
import org.eclipse.jdt.annotation.NonNull;

final class ServletSpec {
    private ServletSpec() {
    }

    static @NonNull String requireContextPath(String str) {
        Preconditions.checkArgument((!str.isEmpty() ? 1 : 0) != 0, (Object)"Context path is empty");
        Preconditions.checkArgument((str.charAt(0) == '/' ? 1 : 0) != 0, (String)"Context path '%s' does not start with '/'", (Object)str);
        Preconditions.checkArgument((str.charAt(str.length() - 1) != '/' ? 1 : 0) != 0, (String)"Context path '%s' ends with '/'", (Object)str);
        return str;
    }

    static @NonNull String requireMappingSpec(String str) {
        if (str.isEmpty()) {
            return "";
        }
        char firstChar = str.charAt(0);
        int len = str.length();
        if (firstChar == '/') {
            if (len != 1) {
                int star = str.indexOf(42, 1);
                Preconditions.checkArgument((star == -1 || star == len - 1 && str.charAt(star - 1) == '/' ? 1 : 0) != 0, (String)"Prefix-based spec '%s' with a '*' at offset %s", (Object)str, (int)star);
            }
        } else {
            Preconditions.checkArgument((firstChar == '.' && len > 1 && str.charAt(1) == '*' ? 1 : 0) != 0, (String)"Spec '%s' is neither prefix-based nor suffix-based", (Object)str);
            int slash = str.indexOf(47, 2);
            Preconditions.checkArgument((slash == -1 ? 1 : 0) != 0, (String)"Suffix-based spec '%s' with a '/' at offset %s", (Object)str, (int)slash);
            int star = str.indexOf(42, 2);
            Preconditions.checkArgument((star == -1 ? 1 : 0) != 0, (String)"Suffix-based spec '%s' with a '*' at offset %s", (Object)str, (int)star);
        }
        return str;
    }
}

