/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.UnsignedLong;

class UnsignedInt
extends UnsignedLong {
    private static final long serialVersionUID = 1079398472598502169L;
    public static final UnsignedInt MAX_VALUE = new UnsignedInt(-1);

    UnsignedInt(int x) {
        super((long)x & 0xFFFFFFFFL);
    }

    public static UnsignedInt make(int x) {
        return (UnsignedInt)UnsignedLong.make((long)x & 0xFFFFFFFFL);
    }

    UnsignedInt makeIfDifferent(int x) {
        if ((int)this.value == x) {
            return this;
        }
        return UnsignedInt.make(x);
    }

    public UnsignedInt add(UnsignedInt x) {
        return this.makeIfDifferent((int)(this.value + x.value));
    }

    public UnsignedInt subtract(UnsignedInt x) {
        return this.makeIfDifferent((int)(this.value - x.value));
    }

    public UnsignedInt multiply(UnsignedInt x) {
        return this.makeIfDifferent((int)(this.value * x.value));
    }

    public UnsignedInt divide(UnsignedInt x) throws ArithmeticException {
        return this.makeIfDifferent((int)(this.value / x.value));
    }

    public UnsignedInt mod(UnsignedInt x) throws ArithmeticException {
        return this.makeIfDifferent((int)(this.value % x.value));
    }

    public UnsignedInt and(UnsignedInt x) {
        return this.makeIfDifferent((int)(this.value & x.value));
    }

    public UnsignedInt or(UnsignedInt x) {
        return this.makeIfDifferent((int)(this.value | x.value));
    }

    public UnsignedInt xor(UnsignedInt x) {
        return this.makeIfDifferent((int)(this.value ^ x.value));
    }

    public UnsignedInt min(UnsignedInt x) {
        if (UnsignedInt.unsignedCompare(this.value, x.value) < 0) {
            return this;
        }
        return x;
    }

    public UnsignedInt max(UnsignedInt x) {
        if (UnsignedInt.unsignedCompare(this.value, x.value) > 0) {
            return this;
        }
        return x;
    }
}

