/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.discovery.ActualDiscovery;
import com.sun.jdmk.discovery.DiscoveryClientMBean;
import com.sun.jdmk.internal.ClassLogger;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Vector;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class DiscoveryClient
implements Serializable,
DiscoveryClientMBean,
MBeanRegistration {
    private static final long serialVersionUID = 2030335665289155729L;
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    private String localClassName = "com.sun.jdmk.discovery.DiscoveryClient";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.discovery", "DiscoveryClient");
    private static final String sccs_id = "@(#)DiscoveryClient.java 4.44 07/03/08 SMI";
    private static int defaultMulticastPort = 9000;
    private static String defaultMulticastGroup = "224.224.224.224";
    private int multicastPort;
    private String multicastGroup;
    private int ttl = 1;
    private boolean pointToPointResponse = true;
    private int timeOut = 1000;
    private static int defaultTimeOut = 1000;
    private transient ActualDiscovery discovery = null;
    private static final String GROUP = "group";
    private static final String PORT = "port";
    protected volatile transient int state = 1;
    InetAddress usrInet = null;

    public DiscoveryClient() {
        this.multicastGroup = defaultMulticastGroup;
        this.multicastPort = defaultMulticastPort;
    }

    public DiscoveryClient(String multicastGroup, int multicastPort) {
        this.multicastGroup = multicastGroup;
        this.multicastPort = multicastPort;
    }

    public DiscoveryClient(String multicastGroup, int multicastPort, InetAddress inf) {
        this.multicastGroup = multicastGroup;
        this.multicastPort = multicastPort;
        this.usrInet = inf;
        if (logger.finerOn()) {
            logger.finer("constructor ", "set interface to " + inf);
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (logger.finerOn()) {
            logger.finer("preRegister ", "object name   = " + name);
        }
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        if (registrationDone == Boolean.FALSE) {
            return;
        }
    }

    public void preDeregister() throws Exception {
        if (logger.finerOn()) {
            logger.finer("preDeregister ", "stopping ");
        }
        if (this.state == 0) {
            this.stop();
        }
    }

    public void postDeregister() {
        System.runFinalization();
    }

    public void start() throws IOException {
        if (this.state == 1) {
            try {
                if (logger.finerOn()) {
                    logger.finer("start ", "Create a new multicast socket");
                    logger.finer("start ", "Set group to '" + this.multicastGroup + "'");
                    logger.finer("start ", "Set port  to '" + this.multicastPort + "'");
                }
                this.discovery = new ActualDiscovery(this.multicastGroup, this.multicastPort);
                if (this.usrInet != null) {
                    this.discovery.setInterface(this.usrInet);
                    if (logger.finerOn()) {
                        logger.finer("start ", "Set to the interface " + this.usrInet);
                    }
                }
            }
            catch (SocketException e) {
                if (logger.finerOn()) {
                    logger.finer("start", "Can't start discoveryClient: Unable to create multicast socket " + this.multicastGroup + ":" + this.multicastPort);
                    logger.finer("start", e);
                }
                throw new IOException(e.getMessage());
            }
            catch (IOException e) {
                if (logger.finerOn()) {
                    logger.finer("start ", "Can't start discoveryClient: Unable to create multicast socket " + this.multicastGroup + ":" + this.multicastPort);
                    logger.finer("start", e);
                }
                throw e;
            }
            try {
                this.discovery.connectToGroup();
                this.discovery.setTimeOut(this.timeOut);
                this.discovery.setTimeToLive(this.ttl);
                this.discovery.setPointToPointResponse(this.pointToPointResponse);
            }
            catch (SocketException e) {
                if (logger.finerOn()) {
                    logger.finer("start", "Can't start discoveryClient: Unable to create multicast socket " + this.multicastGroup + ":" + this.multicastPort);
                    logger.finer("start", e);
                }
                throw new IOException(e.getMessage());
            }
            catch (IOException e) {
                if (logger.finerOn()) {
                    logger.finer("start", "Can't start discoveryClient: Unable to create multicast socket " + this.multicastGroup + ":" + this.multicastPort);
                    logger.finer("start", e);
                }
                throw e;
            }
            this.state = 0;
        } else if (logger.finerOn()) {
            logger.finer("start ", "Client is not OFFLINE");
        }
    }

    public void stop() {
        if (this.state == 0) {
            block6: {
                if (logger.finerOn()) {
                    logger.finer("stop", "Call leave group");
                }
                try {
                    this.discovery.disconnectFromGroup();
                    this.discovery = null;
                }
                catch (IOException e) {
                    if (!logger.finestOn()) break block6;
                    logger.finest("stop ", e);
                }
            }
            System.runFinalization();
            this.state = 1;
        } else if (logger.finerOn()) {
            logger.finer("stop", "Client is not ONLINE");
        }
    }

    public boolean isActive() {
        return this.state == 0;
    }

    public Vector findMBeanServers() throws CommunicationException {
        return this.findCommunicators(false, null);
    }

    public Vector findMBeanServers(String SelectedHost) throws CommunicationException {
        return this.findCommunicators(false, SelectedHost);
    }

    public Vector findCommunicators() throws CommunicationException {
        return this.findCommunicators(true, null);
    }

    public Vector findCommunicators(String SelectedHost) throws CommunicationException {
        return this.findCommunicators(true, SelectedHost);
    }

    public String getMulticastGroup() {
        return this.multicastGroup;
    }

    public void setMulticastGroup(String multicastGroup) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.multicastGroup = multicastGroup;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public void setMulticastPort(int multicastPort) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.multicastPort = multicastPort;
    }

    public void setTimeOut(int timeOut) throws IOException {
        this.timeOut = timeOut <= 0 ? defaultTimeOut : timeOut;
        if (this.state == 0) {
            this.discovery.setTimeOut(timeOut);
        }
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeToLive(int ttl) throws IOException, IllegalArgumentException {
        if (ttl <= 0 || ttl > 255) {
            throw new IllegalArgumentException();
        }
        this.ttl = ttl;
        if (this.state == 0) {
            this.discovery.setTimeToLive(ttl);
        }
    }

    public int getTimeToLive() {
        return this.ttl;
    }

    public boolean getPointToPointResponse() {
        return this.pointToPointResponse;
    }

    public void setPointToPointResponse(boolean pointToPointResponse) {
        this.pointToPointResponse = pointToPointResponse;
        if (this.state == 0) {
            this.discovery.setPointToPointResponse(pointToPointResponse);
        }
    }

    public Integer getState() {
        return new Integer(this.state);
    }

    public String getStateString() {
        String result = "UNKNOWN";
        switch (this.state) {
            case 0: {
                result = "ONLINE";
                break;
            }
            case 1: {
                result = "OFFLINE";
            }
        }
        return result;
    }

    private Vector findCommunicators(boolean adp, String host) throws CommunicationException {
        if (this.state != 0) {
            throw new CommunicationException("Not connected to " + this.multicastGroup + ":" + this.multicastPort);
        }
        try {
            return this.discovery.findCommunicators(adp, host);
        }
        catch (IOException e) {
            if (logger.finestOn()) {
                logger.finest("findCommunicators ", "Get IOException exception " + e.getMessage());
            }
            throw new CommunicationException("Unable to join group on " + this.multicastGroup + ":" + this.multicastPort);
        }
    }
}

