/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.SnmpResponseHandler;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

final class SnmpSocket
implements Runnable {
    private DatagramSocket _socket = null;
    private final SnmpResponseHandler _dgramHdlr;
    private Thread _sockThread = null;
    private byte[] _buffer = null;
    private transient boolean isClosing = false;
    int _socketPort = 0;
    int responseBufSize = 1024;
    String dbgTag = "SnmpSocket";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "SnmpSocket");

    public SnmpSocket(SnmpResponseHandler rspHdlr, InetAddress addr, int bufferSize) throws SocketException {
        if (logger.finerOn()) {
            logger.finer("constructor", "Creating new SNMP datagram socket");
        }
        this._socket = new DatagramSocket(0, addr);
        this._socketPort = this._socket.getLocalPort();
        this.responseBufSize = bufferSize;
        this._buffer = new byte[this.responseBufSize];
        this._dgramHdlr = rspHdlr;
        this._sockThread = new Thread((Runnable)this, "SnmpSocket");
        this._sockThread.start();
    }

    public synchronized void sendPacket(byte[] buff, int length, InetAddress addr, int port) throws IOException {
        DatagramPacket dgrmpkt = new DatagramPacket(buff, length, addr, port);
        this.sendPacket(dgrmpkt);
    }

    public synchronized void sendPacket(DatagramPacket dgrmpkt) throws IOException {
        try {
            if (this.isValid()) {
                if (logger.finerOn()) {
                    logger.finer("sendPacket", "Sending DatagramPacket. Length = " + dgrmpkt.getLength() + " through socket = " + this._socket.toString());
                }
            } else {
                throw new IOException("Invalid state of SNMP datagram socket.");
            }
            this._socket.send(dgrmpkt);
        }
        catch (IOException e) {
            if (logger.finestOn()) {
                logger.finest("sendPacket", "Io error while sending");
                logger.finest("sendPacket", e);
            }
            throw e;
        }
    }

    public synchronized boolean isValid() {
        return this._socket != null && this._sockThread != null && this._sockThread.isAlive();
    }

    public synchronized void close() {
        this.isClosing = true;
        if (logger.finerOn()) {
            logger.finer("close", "Closing and destroying the SNMP datagram socket -> " + this.toString());
        }
        try {
            DatagramSocket sn = new DatagramSocket(0);
            byte[] ob = new byte[1];
            DatagramPacket pk = new DatagramPacket(ob, 1, InetAddress.getLocalHost(), this._socketPort);
            sn.send(pk);
            sn.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
        }
        if (this._sockThread != null && this._sockThread.isAlive()) {
            this._sockThread.interrupt();
            try {
                this._sockThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._sockThread = null;
        }
    }

    public void run() {
        Thread.currentThread().setPriority(8);
        block5: while (true) {
            try {
                while (true) {
                    DatagramPacket dgrmpkt = new DatagramPacket(this._buffer, this._buffer.length);
                    if (logger.finerOn()) {
                        logger.finer("run", "[" + Thread.currentThread().toString() + "]:" + "Blocking for receiving packet");
                    }
                    this._socket.receive(dgrmpkt);
                    if (this.isClosing) break block5;
                    if (logger.finerOn()) {
                        logger.finer("run", "[" + Thread.currentThread().toString() + "]:" + "Received a packet");
                    }
                    if (dgrmpkt.getLength() <= 0) continue;
                    if (logger.finerOn()) {
                        logger.finer("run", "[" + Thread.currentThread().toString() + "]:" + "Received a packet from : " + dgrmpkt.getAddress().toString() + ", Length = " + dgrmpkt.getLength());
                    }
                    this.handleDatagram(dgrmpkt);
                    if (this.isClosing) break;
                }
            }
            catch (IOException io) {
                if (this.isClosing) break;
                if (!logger.finestOn()) continue;
                logger.finest("run", io);
                continue;
            }
            catch (Exception e) {
                if (this.isClosing) break;
                if (!logger.finestOn()) continue;
                logger.finest("run", "Exception in socket thread...");
                logger.finest("run", e);
                continue;
            }
            catch (ThreadDeath d) {
                if (logger.finestOn()) {
                    logger.finest("run", "Socket Thread DEAD..." + this.toString());
                    logger.finest("run", d);
                }
                this.close();
                throw d;
            }
            catch (Error err) {
                if (logger.finestOn()) {
                    logger.finest("run", err);
                }
                this.handleJavaError(err);
                continue;
            }
            break;
        }
    }

    public synchronized void finalize() {
        this.close();
    }

    private synchronized void handleJavaError(Throwable thr) {
        if (thr instanceof OutOfMemoryError) {
            if (logger.finestOn()) {
                logger.finest("handleJavaError", thr);
            }
            Thread.currentThread();
            Thread.yield();
            return;
        }
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
        }
        if (logger.finestOn()) {
            logger.finest("handleJavaError", "Global Internal error");
        }
        Thread.currentThread();
        Thread.yield();
    }

    private void handleDatagram(DatagramPacket dgrmpkt) {
        this._dgramHdlr.processDatagram(dgrmpkt);
    }
}

