/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.internal.snmp;

import com.sun.management.internal.snmp.SnmpModel;
import com.sun.management.internal.snmp.SnmpSubSystem;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpUnknownModelException;
import java.util.Enumeration;
import java.util.Hashtable;

class SnmpSubSystemImpl
implements SnmpSubSystem {
    Hashtable models = new Hashtable();
    SnmpEngine engine = null;

    protected SnmpSubSystemImpl(SnmpEngine engine) {
        this.engine = engine;
    }

    public SnmpEngine getEngine() {
        return this.engine;
    }

    public void addModel(int id, SnmpModel model) {
        this.models.put(new Integer(id), model);
    }

    public SnmpModel removeModel(int id) throws SnmpUnknownModelException {
        SnmpModel mod = (SnmpModel)this.models.remove(new Integer(id));
        if (mod == null) {
            throw new SnmpUnknownModelException("Unknown model: " + id);
        }
        return mod;
    }

    public SnmpModel getModel(int id) throws SnmpUnknownModelException {
        SnmpModel mod = (SnmpModel)this.models.get(new Integer(id));
        if (mod == null) {
            throw new SnmpUnknownModelException("Unknown model: " + id);
        }
        return mod;
    }

    public int[] getModelIds() {
        int[] res = new int[this.models.size()];
        int i = 0;
        Enumeration e = this.models.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            res[i] = key;
            ++i;
        }
        return res;
    }

    public String[] getModelNames() {
        String[] res = new String[this.models.size()];
        int i = 0;
        Enumeration v = this.models.elements();
        Enumeration e = this.models.keys();
        while (e.hasMoreElements()) {
            SnmpModel mod = (SnmpModel)v.nextElement();
            Integer key = (Integer)e.nextElement();
            res[i] = mod.getName() + " (" + key + ")";
            ++i;
        }
        return res;
    }
}

