/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp;

import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpValue;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnmpString
extends SnmpValue {
    private static final long serialVersionUID = -7995335496739639922L;
    static final String name = "String";
    protected byte[] value = null;

    public SnmpString() {
        this.value = new byte[0];
    }

    public SnmpString(byte[] v) {
        this.value = (byte[])v.clone();
    }

    public SnmpString(Byte[] v) {
        this.value = new byte[v.length];
        for (int i = 0; i < v.length; ++i) {
            this.value[i] = v[i];
        }
    }

    public SnmpString(String v) {
        this.value = v.getBytes();
    }

    public SnmpString(InetAddress address) {
        this.value = address.getAddress();
    }

    public InetAddress inetAddressValue() throws UnknownHostException {
        return InetAddress.getByAddress(this.value);
    }

    public static String BinToChar(String bin) {
        char[] value = new char[bin.length() / 8];
        int binLength = value.length;
        for (int i = 0; i < binLength; ++i) {
            value[i] = (char)Integer.parseInt(bin.substring(8 * i, 8 * i + 8), 2);
        }
        return new String(value);
    }

    public static String HexToChar(String hex) {
        char[] value = new char[hex.length() / 2];
        int hexLength = value.length;
        for (int i = 0; i < hexLength; ++i) {
            value[i] = (char)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return new String(value);
    }

    public byte[] byteValue() {
        return this.value;
    }

    public Byte[] toByte() {
        Byte[] result = new Byte[this.value.length];
        for (int i = 0; i < this.value.length; ++i) {
            result[i] = new Byte(this.value[i]);
        }
        return result;
    }

    public String toString() {
        return new String(this.value);
    }

    public SnmpOid toOid() {
        long[] ids = new long[this.value.length];
        for (int i = 0; i < this.value.length; ++i) {
            ids[i] = this.value[i] & 0xFF;
        }
        return new SnmpOid(ids);
    }

    public static SnmpOid toOid(long[] index, int start) throws SnmpStatusException {
        try {
            if (index[start] > Integer.MAX_VALUE) {
                throw new SnmpStatusException(2);
            }
            int strLen = (int)index[start++];
            long[] ids = new long[strLen];
            for (int i = 0; i < strLen; ++i) {
                ids[i] = index[start + i];
            }
            return new SnmpOid(ids);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SnmpStatusException(2);
        }
    }

    public static int nextOid(long[] index, int start) throws SnmpStatusException {
        try {
            int strLen;
            if (index[start] > Integer.MAX_VALUE) {
                throw new SnmpStatusException(2);
            }
            if ((start += (strLen = (int)index[start++])) <= index.length) {
                return start;
            }
            throw new SnmpStatusException(2);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SnmpStatusException(2);
        }
    }

    public static void appendToOid(SnmpOid source, SnmpOid dest) {
        dest.append(source.getLength());
        dest.append(source);
    }

    public final synchronized SnmpValue duplicate() {
        return (SnmpValue)this.clone();
    }

    public synchronized Object clone() {
        SnmpString newclone = null;
        try {
            newclone = (SnmpString)super.clone();
            newclone.value = new byte[this.value.length];
            System.arraycopy(this.value, 0, newclone.value, 0, this.value.length);
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return newclone;
    }

    public String getTypeName() {
        return name;
    }
}

