/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.BerDecoder;
import com.sun.management.snmp.BerEncoder;
import com.sun.management.snmp.BerException;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduBulkType;
import com.sun.management.snmp.SnmpPduRequestType;
import com.sun.management.snmp.SnmpScopedPduBulk;
import com.sun.management.snmp.SnmpScopedPduPacket;
import com.sun.management.snmp.SnmpScopedPduRequest;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTooBigException;

public class SnmpV3Message
extends SnmpMsg {
    public int msgId = 0;
    public int msgMaxSize = 0;
    public byte msgFlags = 0;
    public int msgSecurityModel = 0;
    public byte[] msgSecurityParameters = null;
    public byte[] contextEngineId = null;
    public byte[] contextName = null;
    public byte[] encryptedPdu = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpV3Message");
    String dbgTag = "SnmpV3Message";

    public int encodeMessage(byte[] outputBytes) throws SnmpTooBigException {
        boolean encodingLength = false;
        if (logger.finerOn()) {
            logger.finer("encodeMessage", "Can't encode directly V3Message!!!!! Need a SecuritySubSystem");
        }
        throw new IllegalArgumentException("Can't encode");
    }

    public void decodeMessage(byte[] inputBytes, int byteCount) throws SnmpStatusException {
        try {
            BerDecoder bdec = new BerDecoder(inputBytes);
            bdec.openSequence();
            this.version = bdec.fetchInteger();
            bdec.openSequence();
            this.msgId = bdec.fetchInteger();
            this.msgMaxSize = bdec.fetchInteger();
            this.msgFlags = bdec.fetchOctetString()[0];
            this.msgSecurityModel = bdec.fetchInteger();
            bdec.closeSequence();
            this.msgSecurityParameters = bdec.fetchOctetString();
            if ((this.msgFlags & 2) == 0) {
                bdec.openSequence();
                this.contextEngineId = bdec.fetchOctetString();
                this.contextName = bdec.fetchOctetString();
                this.data = bdec.fetchAny();
                this.dataLength = this.data.length;
                bdec.closeSequence();
            } else {
                this.encryptedPdu = bdec.fetchOctetString();
            }
            bdec.closeSequence();
        }
        catch (BerException x) {
            x.printStackTrace();
            throw new SnmpStatusException("Invalid encoding");
        }
        if (logger.finerOn()) {
            logger.finer("decodeMessage", "Unmarshalled message : \nversion :" + this.version + "\n" + "msgId :" + this.msgId + "\n" + "msgMaxSize :" + this.msgMaxSize + "\n" + "msgFlags :" + this.msgFlags + "\n" + "msgSecurityModel :" + this.msgSecurityModel + "\n" + "contextEngineId :" + (this.contextEngineId == null ? null : SnmpEngineId.createEngineId(this.contextEngineId)) + "\n" + "contextName :" + (this.contextName == null ? null : new String(this.contextName)) + "\n" + "data :" + this.data + "\n" + "dat len :" + (this.data == null ? 0 : this.data.length) + "\n" + "encryptedPdu :" + this.encryptedPdu + "\n");
        }
    }

    public int getRequestId(byte[] data) throws SnmpStatusException {
        BerDecoder bdec = null;
        int msgId = 0;
        try {
            bdec = new BerDecoder(data);
            bdec.openSequence();
            bdec.fetchInteger();
            bdec.openSequence();
            msgId = bdec.fetchInteger();
        }
        catch (BerException x) {
            throw new SnmpStatusException("Invalid encoding");
        }
        try {
            bdec.closeSequence();
        }
        catch (BerException x) {
            // empty catch block
        }
        return msgId;
    }

    public void encodeSnmpPdu(SnmpPdu pdu, int maxDataLength) throws SnmpStatusException, SnmpTooBigException {
        SnmpScopedPduPacket spdu = (SnmpScopedPduPacket)pdu;
        if (logger.finerOn()) {
            logger.finer("encodeSnmpPdu", "Pdu to marshall: \nsecurity parameters : " + spdu.securityParameters + "\n" + "type :" + spdu.type + "\n" + "version :" + spdu.version + "\n" + "requestId :" + spdu.requestId + "\n" + "msgId :" + spdu.msgId + "\n" + "msgMaxSize :" + spdu.msgMaxSize + "\n" + "msgFlags :" + spdu.msgFlags + "\n" + "msgSecurityModel :" + spdu.msgSecurityModel + "\n" + "contextEngineId :" + spdu.contextEngineId + "\n" + "contextName :" + spdu.contextName + "\n");
        }
        this.version = spdu.version;
        this.address = spdu.address;
        this.port = spdu.port;
        this.msgId = spdu.msgId;
        this.msgMaxSize = spdu.msgMaxSize;
        this.msgFlags = spdu.msgFlags;
        this.msgSecurityModel = spdu.msgSecurityModel;
        this.contextEngineId = spdu.contextEngineId;
        this.contextName = spdu.contextName;
        this.securityParameters = spdu.securityParameters;
        this.data = new byte[maxDataLength];
        try {
            BerEncoder benc = new BerEncoder(this.data);
            benc.openSequence();
            this.encodeVarBindList(benc, spdu.varBindList);
            switch (spdu.type) {
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 166: 
                case 167: 
                case 168: {
                    SnmpPduRequestType reqPdu = (SnmpPduRequestType)((Object)spdu);
                    benc.putInteger(reqPdu.getErrorIndex());
                    benc.putInteger(reqPdu.getErrorStatus());
                    benc.putInteger(spdu.requestId);
                    break;
                }
                case 165: {
                    SnmpPduBulkType bulkPdu = (SnmpPduBulkType)((Object)spdu);
                    benc.putInteger(bulkPdu.getMaxRepetitions());
                    benc.putInteger(bulkPdu.getNonRepeaters());
                    benc.putInteger(spdu.requestId);
                    break;
                }
                default: {
                    throw new SnmpStatusException("Invalid pdu type " + String.valueOf(spdu.type));
                }
            }
            benc.closeSequence(spdu.type);
            this.dataLength = benc.trim();
        }
        catch (ArrayIndexOutOfBoundsException x) {
            throw new SnmpTooBigException();
        }
    }

    public SnmpPdu decodeSnmpPdu() throws SnmpStatusException {
        SnmpScopedPduPacket pdu = null;
        BerDecoder bdec = new BerDecoder(this.data);
        try {
            int type = bdec.getTag();
            bdec.openSequence(type);
            switch (type) {
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 166: 
                case 167: 
                case 168: {
                    SnmpScopedPduRequest reqPdu = new SnmpScopedPduRequest();
                    reqPdu.requestId = bdec.fetchInteger();
                    reqPdu.setErrorStatus(bdec.fetchInteger());
                    reqPdu.setErrorIndex(bdec.fetchInteger());
                    pdu = reqPdu;
                    break;
                }
                case 165: {
                    SnmpScopedPduBulk bulkPdu = new SnmpScopedPduBulk();
                    bulkPdu.requestId = bdec.fetchInteger();
                    bulkPdu.setNonRepeaters(bdec.fetchInteger());
                    bulkPdu.setMaxRepetitions(bdec.fetchInteger());
                    pdu = bulkPdu;
                    break;
                }
                default: {
                    throw new SnmpStatusException(9);
                }
            }
            pdu.type = type;
            pdu.varBindList = this.decodeVarBindList(bdec);
            bdec.closeSequence();
        }
        catch (BerException e) {
            if (logger.finestOn()) {
                logger.finest("decodeSnmpPdu", e);
            }
            throw new SnmpStatusException(9);
        }
        pdu.address = this.address;
        pdu.port = this.port;
        pdu.msgFlags = this.msgFlags;
        pdu.version = this.version;
        pdu.msgId = this.msgId;
        pdu.msgMaxSize = this.msgMaxSize;
        pdu.msgSecurityModel = this.msgSecurityModel;
        pdu.contextEngineId = this.contextEngineId;
        pdu.contextName = this.contextName;
        pdu.securityParameters = this.securityParameters;
        if (logger.finerOn()) {
            logger.finer("decodeSnmpPdu", "Unmarshalled pdu : \ntype :" + pdu.type + "\n" + "version :" + pdu.version + "\n" + "requestId :" + pdu.requestId + "\n" + "msgId :" + pdu.msgId + "\n" + "msgMaxSize :" + pdu.msgMaxSize + "\n" + "msgFlags :" + pdu.msgFlags + "\n" + "msgSecurityModel :" + pdu.msgSecurityModel + "\n" + "contextEngineId :" + pdu.contextEngineId + "\n" + "contextName :" + pdu.contextName + "\n");
        }
        return pdu;
    }

    public String printMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append("msgId : " + this.msgId + "\n");
        sb.append("msgMaxSize : " + this.msgMaxSize + "\n");
        sb.append("msgFlags : " + this.msgFlags + "\n");
        sb.append("msgSecurityModel : " + this.msgSecurityModel + "\n");
        if (this.contextEngineId == null) {
            sb.append("contextEngineId : null");
        } else {
            sb.append("contextEngineId : {\n");
            sb.append(SnmpV3Message.dumpHexBuffer(this.contextEngineId, 0, this.contextEngineId.length));
            sb.append("\n}\n");
        }
        if (this.contextName == null) {
            sb.append("contextName : null");
        } else {
            sb.append("contextName : {\n");
            sb.append(SnmpV3Message.dumpHexBuffer(this.contextName, 0, this.contextName.length));
            sb.append("\n}\n");
        }
        return sb.append(super.printMessage()).toString();
    }
}

