/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.agent.AcmChecker;
import com.sun.management.snmp.agent.SnmpMibNode;
import com.sun.management.snmp.agent.SnmpMibOid;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpMibTable;
import com.sun.management.snmp.agent.SnmpRequestTree;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public abstract class SnmpMibGroup
extends SnmpMibOid
implements Serializable {
    protected Hashtable subgroups = null;

    public abstract boolean isTable(long var1);

    public abstract boolean isVariable(long var1);

    public abstract boolean isReadable(long var1);

    public abstract SnmpMibTable getTable(long var1);

    public void validateVarId(long arc, Object userData) throws SnmpStatusException {
        if (!this.isVariable(arc)) {
            throw noSuchObjectException;
        }
    }

    public boolean isNestedArc(long arc) {
        if (this.subgroups == null) {
            return false;
        }
        Object obj = this.subgroups.get(new Long(arc));
        return obj != null;
    }

    public abstract void get(SnmpMibSubRequest var1, int var2) throws SnmpStatusException;

    public abstract void set(SnmpMibSubRequest var1, int var2) throws SnmpStatusException;

    public abstract void check(SnmpMibSubRequest var1, int var2) throws SnmpStatusException;

    public void getRootOid(Vector result) {
    }

    void registerNestedArc(long arc) {
        Long obj = new Long(arc);
        if (this.subgroups == null) {
            this.subgroups = new Hashtable();
        }
        this.subgroups.put(obj, obj);
    }

    protected void registerObject(long arc) throws IllegalAccessException {
        long[] oid = new long[]{arc};
        super.registerNode(oid, 0, null);
    }

    void registerNode(long[] oid, int cursor, SnmpMibNode node) throws IllegalAccessException {
        super.registerNode(oid, cursor, node);
        if (cursor < 0) {
            return;
        }
        if (cursor >= oid.length) {
            return;
        }
        this.registerNestedArc(oid[cursor]);
    }

    void findHandlingNode(SnmpVarBind varbind, long[] oid, int depth, SnmpRequestTree handlers) throws SnmpStatusException {
        int length = oid.length;
        Object node = null;
        if (handlers == null) {
            throw new SnmpStatusException(5);
        }
        Object data = handlers.getUserData();
        if (depth >= length) {
            throw new SnmpStatusException(6);
        }
        long arc = oid[depth];
        if (this.isNestedArc(arc)) {
            super.findHandlingNode(varbind, oid, depth, handlers);
            return;
        }
        if (this.isTable(arc)) {
            SnmpMibTable table = this.getTable(arc);
            table.findHandlingNode(varbind, oid, depth + 1, handlers);
        } else {
            this.validateVarId(arc, data);
            if (depth + 2 > length) {
                throw noSuchInstanceException;
            }
            if (depth + 2 < length) {
                throw noSuchInstanceException;
            }
            if (oid[depth + 1] != 0L) {
                throw noSuchInstanceException;
            }
            handlers.add(this, depth, varbind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long[] findNextHandlingNode(SnmpVarBind varbind, long[] oid, int pos, int depth, SnmpRequestTree handlers, AcmChecker checker) throws SnmpStatusException {
        int length = oid.length;
        Object node = null;
        if (handlers == null) {
            throw noSuchObjectException;
        }
        Object data = handlers.getUserData();
        int pduVersion = handlers.getRequestPduVersion();
        if (pos >= length) {
            return super.findNextHandlingNode(varbind, oid, pos, depth, handlers, checker);
        }
        long arc = oid[pos];
        long[] result = null;
        try {
            if (this.isTable(arc)) {
                SnmpMibTable table = this.getTable(arc);
                checker.add(depth, arc);
                try {
                    result = table.findNextHandlingNode(varbind, oid, pos + 1, depth + 1, handlers, checker);
                }
                catch (SnmpStatusException ex) {
                    throw noSuchObjectException;
                }
                finally {
                    checker.remove(depth);
                }
                result[depth] = arc;
                return result;
            }
            if (this.isReadable(arc)) {
                if (pos != length - 1) throw noSuchObjectException;
                result = new long[depth + 2];
                result[depth + 1] = 0L;
                result[depth] = arc;
                checker.add(depth, result, depth, 2);
                try {
                    checker.checkCurrentOid();
                }
                catch (SnmpStatusException e) {
                    throw noSuchObjectException;
                }
                finally {
                    checker.remove(depth, 2);
                }
                handlers.add(this, depth, varbind);
                return result;
            }
            if (!this.isNestedArc(arc)) throw noSuchObjectException;
            SnmpMibNode child = this.getChild(arc);
            if (child == null) throw noSuchObjectException;
            checker.add(depth, arc);
            try {
                result = child.findNextHandlingNode(varbind, oid, pos + 1, depth + 1, handlers, checker);
                result[depth] = arc;
                long[] ex = result;
                return ex;
            }
            finally {
                checker.remove(depth);
            }
        }
        catch (SnmpStatusException e) {
            long[] newOid = new long[]{this.getNextVarId(arc, data, pduVersion)};
            return this.findNextHandlingNode(varbind, newOid, 0, depth, handlers, checker);
        }
    }
}

